/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.leanplum.Leanplum;
import com.leanplum.LeanplumNotificationHelper;
import com.leanplum.LeanplumPushService;
import com.leanplum.internal.Log;
import java.util.HashMap;

public class PushTracking {
    static final String CHANNEL_FCM = "FCM";
    static final String CHANNEL_FCM_SILENT_TRACK = "FCM_SILENT_TRACK";
    static final String CHANNEL_MIPUSH = "MIPUSH";
    static final String CHANNEL_HMS = "HMS";

    static boolean isFcmSilentPush(@NonNull Bundle message) {
        String channel = message.getString("_channel_internal");
        return CHANNEL_FCM_SILENT_TRACK.equals(channel);
    }

    public static void trackDelivery(@NonNull Context context, @NonNull Bundle message) {
        String channel;
        String sentTime;
        if (!Leanplum.isPushDeliveryTrackingEnabled()) {
            Log.d((String)("Push delivery tracking is disabled for " + LeanplumPushService.getMessageId(message)), (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("messageID", LeanplumPushService.getMessageId(message));
        String occurrenceId = message.getString("lp_occurrence_id");
        if (!TextUtils.isEmpty((CharSequence)occurrenceId)) {
            properties.put("occurrenceId", occurrenceId);
        }
        if (!TextUtils.isEmpty((CharSequence)(sentTime = message.getString("lp_sent_time")))) {
            properties.put("sentTime", sentTime);
        }
        if (!TextUtils.isEmpty((CharSequence)(channel = message.getString("_channel_internal")))) {
            properties.put("channel", channel);
        }
        boolean notificationsEnabled = LeanplumNotificationHelper.areNotificationsEnabled(context, message);
        properties.put("notificationsEnabled", Boolean.toString(notificationsEnabled));
        Leanplum.track((String)"Push Delivered", properties);
    }

    public static void trackOpen(@NonNull Bundle message) {
        String channel;
        String sentTime;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("messageID", LeanplumPushService.getMessageId(message));
        String occurrenceId = message.getString("lp_occurrence_id");
        if (!TextUtils.isEmpty((CharSequence)occurrenceId)) {
            properties.put("occurrenceId", occurrenceId);
        }
        if (!TextUtils.isEmpty((CharSequence)(sentTime = message.getString("lp_sent_time")))) {
            properties.put("sentTime", sentTime);
        }
        if (!TextUtils.isEmpty((CharSequence)(channel = message.getString("_channel_internal")))) {
            properties.put("channel", channel);
        }
        Leanplum.track((String)"Push Opened", properties);
    }
}

