/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import com.leanplum.ActionContext;
import com.leanplum.Leanplum;
import com.leanplum.LeanplumLocalPushListenerService;
import com.leanplum.internal.Clock;
import com.leanplum.internal.CollectionUtil;
import com.leanplum.internal.Log;
import com.leanplum.internal.Util;
import com.leanplum.internal.VarCache;
import com.leanplum.utils.BuildUtil;
import com.leanplum.utils.SharedPreferencesUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

class LeanplumLocalPushHelper {
    LeanplumLocalPushHelper() {
    }

    static boolean scheduleLocalPush(@NonNull ActionContext actionContext) {
        try {
            Double countdownObj;
            String messageId = actionContext.getMessageId();
            if (actionContext.isPreview()) {
                countdownObj = 5.0;
            } else {
                Map messageConfig = (Map)CollectionUtil.uncheckedCast(VarCache.getMessageDiffs().get(messageId));
                if (messageConfig == null) {
                    Log.e((String)("Could not find message options for ID " + messageId), (Object[])new Object[0]);
                    return false;
                }
                countdownObj = messageConfig.get("countdown");
            }
            if (!(countdownObj instanceof Number)) {
                Log.e((String)("Invalid notification countdown: " + countdownObj), (Object[])new Object[0]);
                return false;
            }
            long eta = Clock.getInstance().currentTimeMillis() + ((Number)countdownObj).longValue() * 1000L;
            return LeanplumLocalPushHelper.scheduleAlarm(actionContext, messageId, eta);
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
            return false;
        }
    }

    private static boolean scheduleAlarm(ActionContext actionContext, String messageId, long eta) {
        try {
            boolean delayWhileIdle;
            Map data;
            Context context = Leanplum.getContext();
            Intent intentAlarm = LeanplumLocalPushListenerService.getIntent(context);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            SharedPreferences preferences = context.getSharedPreferences("__leanplum_messaging__", 0);
            long existingEta = preferences.getLong(String.format("__leanplum_local_message_%s", messageId), 0L);
            if (existingEta > 0L && existingEta > System.currentTimeMillis()) {
                if (existingEta < eta) {
                    return false;
                }
                if (existingEta >= eta) {
                    PendingIntent existingIntent = PendingIntent.getBroadcast((Context)context, (int)messageId.hashCode(), (Intent)intentAlarm, (int)BuildUtil.createIntentFlags((int)0x8000000));
                    alarmManager.cancel(existingIntent);
                }
            }
            if ((data = (Map)actionContext.objectNamed("Advanced options.Data")) != null) {
                for (String key : data.keySet()) {
                    intentAlarm.putExtra(key, (Serializable)data.get(key));
                }
            }
            intentAlarm.putExtra("lp_occurrence_id", UUID.randomUUID().toString());
            String openAction = actionContext.stringNamed("Open action");
            boolean muteInsideApp = Boolean.TRUE.equals(actionContext.objectNamed("Advanced options.Mute inside app"));
            if (openAction != null) {
                if (muteInsideApp) {
                    intentAlarm.putExtra("_lpu", messageId);
                } else {
                    intentAlarm.putExtra("_lpm", messageId);
                }
            } else if (muteInsideApp) {
                intentAlarm.putExtra("_lpv", messageId);
            } else {
                intentAlarm.putExtra("_lpn", messageId);
            }
            String message = actionContext.stringNamed("Message");
            intentAlarm.putExtra("lp_message", message != null ? message : "Push message goes here.");
            String collapseKey = actionContext.stringNamed("Android options.Collapse key");
            if (collapseKey != null) {
                intentAlarm.putExtra("collapseKey", collapseKey);
            }
            if (delayWhileIdle = Boolean.TRUE.equals(actionContext.objectNamed("Android options.Delay while idle"))) {
                intentAlarm.putExtra("delayWhileIdle", true);
            }
            PendingIntent operation = PendingIntent.getBroadcast((Context)context, (int)messageId.hashCode(), (Intent)intentAlarm, (int)BuildUtil.createIntentFlags((int)0x8000000));
            if (Build.VERSION.SDK_INT >= 19 && Util.isXiaomiDevice()) {
                alarmManager.setExact(0, eta, operation);
            } else {
                alarmManager.set(0, eta, operation);
            }
            SharedPreferences.Editor editor = preferences.edit();
            editor.putLong(String.format("__leanplum_local_message_%s", messageId), eta);
            SharedPreferencesUtil.commitChanges((SharedPreferences.Editor)editor);
            Log.i((String)"Scheduling local notification.", (Object[])new Object[0]);
            return true;
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
            return false;
        }
    }

    static boolean cancelLocalPush(@NonNull String messageId) {
        try {
            boolean didCancel;
            Context context = Leanplum.getContext();
            SharedPreferences preferences = context.getSharedPreferences("__leanplum_messaging__", 0);
            String preferencesKey = String.format("__leanplum_local_message_%s", messageId);
            long existingEta = preferences.getLong(preferencesKey, 0L);
            SharedPreferences.Editor editor = preferences.edit();
            editor.remove(preferencesKey);
            SharedPreferencesUtil.commitChanges((SharedPreferences.Editor)editor);
            LeanplumLocalPushHelper.cancelAlarm(context, messageId);
            boolean bl = didCancel = existingEta > Clock.getInstance().currentTimeMillis();
            if (didCancel) {
                Log.i((String)"Cancelled notification", (Object[])new Object[0]);
            }
            return didCancel;
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
            return false;
        }
    }

    private static void cancelAlarm(Context context, String messageId) {
        try {
            Intent intentAlarm = LeanplumLocalPushListenerService.getIntent(context);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            PendingIntent existingIntent = PendingIntent.getBroadcast((Context)context, (int)messageId.hashCode(), (Intent)intentAlarm, (int)BuildUtil.createIntentFlags((int)0x8000000));
            if (alarmManager != null && existingIntent != null) {
                alarmManager.cancel(existingIntent);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

