/*
 * Decompiled with CFR 0.152.
 */
package com.leanplum.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.leanplum.Leanplum;
import com.leanplum.internal.Log;

public class LeanplumManifestHelper {
    public static Class getClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean enableServiceAndStart(Context context, PackageManager packageManager, Class clazz) {
        if (!LeanplumManifestHelper.enableComponent(context, packageManager, clazz)) {
            return false;
        }
        try {
            context.startService(new Intent(context, clazz));
        }
        catch (Throwable t) {
            Log.i((String)"Could not start service for class: %s", (Object[])new Object[]{clazz.getName()});
            return false;
        }
        return true;
    }

    public static boolean enableComponent(Context context, PackageManager packageManager, Class clazz) {
        if (clazz == null || context == null || packageManager == null) {
            return false;
        }
        try {
            packageManager.setComponentEnabledSetting(new ComponentName(context, clazz), 1, 1);
        }
        catch (Throwable t) {
            Log.i((String)"Could not enable component: %s", (Object[])new Object[]{clazz.getName()});
            return false;
        }
        return true;
    }

    public static boolean disableComponent(Context context, PackageManager packageManager, String className) {
        if (context == null || packageManager == null || className == null) {
            return false;
        }
        try {
            packageManager.setComponentEnabledSetting(new ComponentName(context, className), 2, 1);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static boolean wasComponentEnabled(Context context, PackageManager packageManager, Class clazz) {
        if (clazz == null || context == null || packageManager == null) {
            return false;
        }
        int componentStatus = packageManager.getComponentEnabledSetting(new ComponentName(context, clazz));
        return 0 != componentStatus && 2 != componentStatus;
    }

    public static String parseNotificationMetadata() {
        try {
            Context context = Leanplum.getContext();
            ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = app.metaData;
            return bundle.getString("LP_NOTIFICATION");
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

