/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mock.client;

import com.legstar.messaging.ConnectionException;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.LegStarConnection;
import com.legstar.messaging.LegStarRequest;
import com.legstar.messaging.RequestException;
import com.legstar.mock.client.MockLsfileac;
import com.legstar.mock.client.MockLsfileae;
import com.legstar.mock.client.MockLsfileal;
import com.legstar.mock.client.MockT1sleep;
import com.legstar.mock.client.MockVararcom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class MockConnection
implements LegStarConnection {
    private final Log _log = LogFactory.getLog(MockConnection.class);
    private String _connectionID;
    private long _lastUsedTime = -1L;
    private boolean _isOpen;

    public MockConnection() {
    }

    public MockConnection(String connectionID) {
        this._connectionID = connectionID;
    }

    public void close() throws RequestException {
        this._lastUsedTime = System.currentTimeMillis();
        this._isOpen = false;
    }

    public void commitUOW() throws RequestException {
    }

    public void connect(String password) throws ConnectionException {
        this._lastUsedTime = System.currentTimeMillis();
        this._isOpen = true;
    }

    public void connectReuse(String password) throws ConnectionException {
        this._lastUsedTime = System.currentTimeMillis();
        this._isOpen = true;
    }

    public long getConnectTimeout() {
        return 0L;
    }

    public String getConnectionID() {
        return this._connectionID;
    }

    public long getReceiveTimeout() {
        return 0L;
    }

    public void keepUOW() throws RequestException {
    }

    public void recvResponse(LegStarRequest request) throws RequestException {
        try {
            JSONObject jsonObj;
            String programName;
            String jsonString = request.getRequestMessage().getHeaderPart().getJsonString();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Mocking program execution: " + jsonString));
            }
            if ((programName = (String)(jsonObj = new JSONObject(jsonString)).get("CICSProgramName")).equals("LSFILEAE")) {
                request.setResponseMessage(MockLsfileae.getResponse(request.getRequestMessage()));
            } else if (programName.equals("LSFILEAC")) {
                request.setResponseMessage(MockLsfileac.getResponse(request.getRequestMessage()));
            } else if (programName.equals("LSFILEAL")) {
                request.setResponseMessage(MockLsfileal.getResponse(request.getRequestMessage()));
            } else if (programName.equals("VARARCOM")) {
                request.setResponseMessage(MockVararcom.getResponse(request.getRequestMessage()));
            } else if (programName.equals("T1SLEEPT")) {
                request.setResponseMessage(MockT1sleep.getResponse(request.getRequestMessage()));
            } else {
                throw new RequestException("CICS command=LINK COMMAREA failed, resp=PGMIDERR, resp2=3");
            }
            this._lastUsedTime = System.currentTimeMillis();
        }
        catch (HeaderPartException e) {
            throw new RequestException((Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new RequestException((Exception)((Object)e));
        }
    }

    public void rollbackUOW() throws RequestException {
    }

    public void sendRequest(LegStarRequest request) throws RequestException {
        if (!this.isOpen()) {
            throw new RequestException("Connection is closed.");
        }
        this._lastUsedTime = System.currentTimeMillis();
    }

    public void setConnectTimeout(long timeout) {
    }

    public void setReceiveTimeout(long timeout) {
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public long getLastUsedTime() {
        return this._lastUsedTime;
    }
}

