/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.mock.client;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.simple.CobolBinarySimpleConverter;
import com.legstar.coxb.convert.simple.CobolPackedDecimalSimpleConverter;
import com.legstar.coxb.convert.simple.CobolStringSimpleConverter;
import com.legstar.messaging.CommareaPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.LegStarMessage;
import com.legstar.messaging.LegStarMessagePart;
import com.legstar.messaging.RequestException;
import com.legstar.mock.client.MockFILEA;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MockLsfileaq {
    private static final MockFILEA FILEA = new MockFILEA();
    private static final Log LOG = LogFactory.getLog(MockLsfileaq.class);

    private MockLsfileaq() {
    }

    public static LegStarMessage getResponse(LegStarMessage requestMessage) throws RequestException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Building response for program LSFILEAQ");
        }
        try {
            byte[] hostRequest = ((LegStarMessagePart)requestMessage.getDataParts().get(0)).getContent();
            String namePattern = MockLsfileaq.getQueryName(hostRequest);
            byte[] hostMaxItems = new byte[2];
            System.arraycopy(hostRequest, 20, hostMaxItems, 0, 2);
            long maxReplies = MockLsfileaq.getMaxReplies(hostMaxItems);
            List<byte[]> customers = FILEA.getCustomers(namePattern, -1L, maxReplies);
            byte[] hostReplyData = new byte[hostRequest.length + 5 + 79 * customers.size()];
            int offset = 0;
            System.arraycopy(hostRequest, 0, hostReplyData, offset, hostRequest.length);
            CobolPackedDecimalSimpleConverter.toHostSingle((BigDecimal)new BigDecimal(customers.size()), (int)5, (int)8, (int)0, (boolean)false, (byte[])hostReplyData, (int)(offset += hostRequest.length));
            offset += 5;
            for (byte[] customer : customers) {
                System.arraycopy(customer, 0, hostReplyData, offset, 79);
                offset += 79;
            }
            LegStarMessage replyMessage = new LegStarMessage();
            replyMessage.addDataPart((LegStarMessagePart)new CommareaPart(hostReplyData));
            return replyMessage;
        }
        catch (HeaderPartException e) {
            throw new RequestException((Exception)((Object)e));
        }
        catch (CobolConversionException e) {
            throw new RequestException((Exception)((Object)e));
        }
    }

    private static String getQueryName(byte[] hostData) {
        try {
            return CobolStringSimpleConverter.fromHostSingle((String)CobolContext.getDefaultHostCharsetName(), (int)20, (byte[])hostData, (int)0);
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long getMaxReplies(byte[] hostData) {
        try {
            BigDecimal bigD = CobolBinarySimpleConverter.fromHostSingle((int)2, (boolean)true, (int)4, (int)0, (byte[])hostData, (int)0);
            return bigD.longValue();
        }
        catch (CobolConversionException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

