/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.host;

import com.legstar.coxb.host.HostData;

public class HostException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String mHostFieldMessage = null;

    public HostException(String message) {
        super(message);
    }

    public HostException(String message, HostData hostField, int errorOffset) {
        super(message);
        this.mHostFieldMessage = this.getMessage(hostField, errorOffset, hostField.length());
    }

    public HostException(String message, HostData hostField, int errorOffset, int errorLength) {
        super(message);
        this.mHostFieldMessage = this.getMessage(hostField, errorOffset, errorLength);
    }

    public HostException(Exception e) {
        super(e);
    }

    private String getMessage(HostData hostField, int hostFieldErrorOffset, int hostFieldErrorLength) {
        String message = super.getMessage();
        if (hostField != null) {
            if (hostFieldErrorOffset > hostField.length()) {
                message = message + ". Host data=0x" + hostField.toHexString();
            } else {
                int restl = hostField.length() - hostFieldErrorOffset;
                if (hostFieldErrorLength == 0 || hostFieldErrorLength > restl) {
                    byte[] restOfBuffer = new byte[restl];
                    System.arraycopy(hostField.getHostData(), hostFieldErrorOffset, restOfBuffer, 0, restl);
                    message = message + ". Host data at offset " + hostFieldErrorOffset + "=0x" + HostData.toHexString(restOfBuffer);
                } else {
                    byte[] errorBuffer = new byte[hostFieldErrorLength];
                    System.arraycopy(hostField.getHostData(), hostFieldErrorOffset, errorBuffer, 0, hostFieldErrorLength);
                    message = message + ". Host data at offset " + hostFieldErrorOffset + "=0x" + HostData.toHexString(errorBuffer);
                }
            }
        }
        return message;
    }

    public String getMessage() {
        if (this.mHostFieldMessage != null) {
            return this.mHostFieldMessage;
        }
        return super.getMessage();
    }

    public String toString() {
        return this.getMessage();
    }
}

