/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IJavaToHostTransformer;
import com.legstar.coxb.transform.IJsonToHostTransformer;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public abstract class AbstractJsonToHostTransformer
implements IJsonToHostTransformer {
    private final Log _log = LogFactory.getLog(AbstractJsonToHostTransformer.class);
    private IJavaToHostTransformer _javaToHostTransformer;
    private ObjectMapper _jsonMapper;

    public AbstractJsonToHostTransformer(IJavaToHostTransformer javaToHostTransformer) throws HostTransformException {
        this._javaToHostTransformer = javaToHostTransformer;
        this._jsonMapper = new ObjectMapper();
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this._jsonMapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this._jsonMapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public byte[] transform(Reader reader, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Transforming JSON to host data:");
        }
        return this.getJavaToHostTransformer().transform(this.getObjectFromJson(reader), hostCharset, status);
    }

    public byte[] transform(Reader reader, HostTransformStatus status) throws HostTransformException {
        return this.transform(reader, null, status);
    }

    public byte[] transform(Reader reader, String hostCharset) throws HostTransformException {
        return this.transform(reader, hostCharset, new HostTransformStatus());
    }

    public byte[] transform(Reader reader) throws HostTransformException {
        return this.transform(reader, (String)null);
    }

    public Object getObjectFromJson(Reader reader) throws HostTransformException {
        try {
            return this._jsonMapper.readValue(reader, this.getJavaToHostTransformer().newBinding().getJaxbType());
        }
        catch (CobolBindingException e) {
            throw new HostTransformException(e);
        }
        catch (JsonParseException e) {
            throw new HostTransformException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new HostTransformException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new HostTransformException(e);
        }
    }

    public IJavaToHostTransformer getJavaToHostTransformer() {
        return this._javaToHostTransformer;
    }
}

