/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.common;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolMarshalChoiceStrategy;
import com.legstar.coxb.ICobolUnmarshalChoiceStrategy;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CChoiceBinding
extends CBinding
implements ICobolChoiceBinding {
    private List<ICobolBinding> mAlternatives = new ArrayList<ICobolBinding>();
    private ICobolMarshalChoiceStrategy mMarshalChoiceStrategy;
    private ICobolUnmarshalChoiceStrategy mUnmarshalChoiceStrategy;

    public CChoiceBinding(String bindingName, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, null, null, cobolAnnotations, parentBinding);
    }

    @Override
    public void addAlternative(ICobolBinding ce) {
        this.mAlternatives.add(ce);
    }

    @Override
    public List<ICobolBinding> getAlternativesList() {
        return this.mAlternatives;
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public int calcByteLength() {
        int byteLength = 0;
        for (ICobolBinding alt : this.mAlternatives) {
            int altByteLength = alt.getByteLength();
            if (altByteLength <= byteLength) continue;
            byteLength = altByteLength;
        }
        return byteLength;
    }

    @Override
    public ICobolBinding getAlternativeByName(String name) {
        for (ICobolBinding alt : this.mAlternatives) {
            if (alt.getBindingName().compareTo(name) != 0) continue;
            return alt;
        }
        return null;
    }

    @Override
    public ICobolBinding getAlternativeByCobolName(String cobolName) {
        for (ICobolBinding alt : this.mAlternatives) {
            if (alt.getCobolName().compareTo(cobolName) != 0) continue;
            return alt;
        }
        return null;
    }

    @Override
    public ICobolMarshalChoiceStrategy getMarshalChoiceStrategy() throws HostException {
        if (this.mMarshalChoiceStrategy == null) {
            this.mMarshalChoiceStrategy = (ICobolMarshalChoiceStrategy)this.loadStrategy(this.getMarshalChoiceStrategyClassName());
        }
        return this.mMarshalChoiceStrategy;
    }

    @Override
    public void setMarshalChoiceStrategy(ICobolMarshalChoiceStrategy strategy) {
        this.mMarshalChoiceStrategy = strategy;
    }

    @Override
    public ICobolUnmarshalChoiceStrategy getUnmarshalChoiceStrategy() throws HostException {
        if (this.mUnmarshalChoiceStrategy == null) {
            this.mUnmarshalChoiceStrategy = (ICobolUnmarshalChoiceStrategy)this.loadStrategy(this.getUnmarshalChoiceStrategyClassName());
        }
        return this.mUnmarshalChoiceStrategy;
    }

    @Override
    public void setUnmarshalChoiceStrategy(ICobolUnmarshalChoiceStrategy strategy) {
        this.mUnmarshalChoiceStrategy = strategy;
    }

    @Override
    public Object getParentJaxbObject() throws HostException {
        return this.getParentBinding().getObjectValue(this.getParentBinding().getJaxbType());
    }

    private Object loadStrategy(String strategyClassName) throws HostException {
        if (strategyClassName != null && strategyClassName.length() > 0) {
            try {
                Class<?> clazz = ClassUtil.loadClass(strategyClassName);
                return clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new HostException(e);
            }
            catch (IllegalAccessException e) {
                throw new HostException(e);
            }
            catch (InstantiationException e) {
                throw new HostException(e);
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int index) throws HostException {
        this.setJaxbPropertyValue(index);
    }

    @Override
    public void setJaxbPropertyValue(int index) throws HostException {
        throw new HostException("setJaxbPropertyValue is deprecated");
    }

    @Override
    public Object getParentValueObject() throws HostException {
        return this.getParentJaxbObject();
    }
}

