/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.common;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolNumericBinding;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CComplexBinding
extends CBinding
implements ICobolComplexBinding {
    private List<ICobolBinding> mChildren = new LinkedList<ICobolBinding>();
    private int mDynamicCountersCount = 0;
    private String mValueObjectClassName;
    private String mValueObjectsFactoryClassName;

    public CComplexBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public int calcByteLength() {
        long byteLength = 0L;
        for (ICobolBinding child : this.mChildren) {
            byteLength += (long)child.getByteLength();
        }
        return byteLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)byteLength;
    }

    @Override
    public List<ICobolBinding> getChildrenList() {
        return this.mChildren;
    }

    public void setChildrenList(List<ICobolBinding> children) {
        this.mChildren = children;
    }

    @Override
    public void storeCounter(ICobolNumericBinding counter) {
        if (this.getParentBinding() == null) {
            if (this.getChildrenList().size() > 0) {
                counter.setLevelNumber(this.getChildrenList().get(0).getLevelNumber());
            }
            this.getChildrenList().add(this.mDynamicCountersCount, counter);
            ++this.mDynamicCountersCount;
        } else {
            this.getParentBinding().storeCounter(counter);
        }
    }

    @Override
    public void storeCounter(ICobolBinding counter) {
        this.storeCounter((ICobolNumericBinding)counter);
    }

    @Override
    public void setCounterValue(String cobolName, int count) throws HostException {
        ICobolNumericBinding counter = this.getCounter(cobolName);
        counter.setIntegerValue(count);
    }

    @Override
    public int getCounterValue(String cobolName) throws HostException {
        ICobolNumericBinding counter = this.getCounter(cobolName);
        return counter.getIntegerValue();
    }

    @Override
    public ICobolNumericBinding getCounter(String cobolName) throws HostException {
        if (this.getParentBinding() == null) {
            ICobolNumericBinding counter = this.getCounterInChildren(this.getChildrenList(), cobolName);
            if (counter == null) {
                throw new HostException("Cannot locate counter " + cobolName);
            }
            return counter;
        }
        return this.getParentBinding().getCounter(cobolName);
    }

    protected ICobolNumericBinding getCounterInChildren(List<ICobolBinding> children, String cobolName) throws HostException {
        ICobolNumericBinding counter = null;
        for (ICobolBinding child : children) {
            if (!(child instanceof ICobolNumericBinding) || !child.getCobolName().equals(cobolName)) continue;
            return (ICobolNumericBinding)child;
        }
        for (ICobolBinding child : children) {
            if (child instanceof ICobolComplexBinding) {
                counter = this.getCounterInChildren(((ICobolComplexBinding)child).getChildrenList(), cobolName);
            } else if (child instanceof ICobolChoiceBinding) {
                counter = this.getCounterInChildren(((ICobolChoiceBinding)child).getAlternativesList(), cobolName);
            } else if (child instanceof ICobolArrayComplexBinding) {
                counter = this.getCounterInChildren(((ICobolArrayComplexBinding)child).getComplexItemBinding().getChildrenList(), cobolName);
            }
            if (counter == null) continue;
            return counter;
        }
        return counter;
    }

    @Override
    public int getDynamicCountersCount() {
        return this.mDynamicCountersCount;
    }

    @Override
    public void createValueObject() throws HostException {
        this.createJaxbObject();
    }

    @Override
    public void setPropertyValue(int index) throws HostException {
        this.setJaxbPropertyValue(index);
    }

    @Override
    public void createJaxbObject() throws HostException {
    }

    @Override
    public void setJaxbPropertyValue(int index) throws HostException {
    }

    @Override
    public String getValueObjectClassName() {
        return this.mValueObjectClassName;
    }

    @Override
    public void setValueObjectClassName(String valueObjectClassName) {
        this.mValueObjectClassName = valueObjectClassName;
    }

    @Override
    public String getValueObjectsFactoryClassName() {
        return this.mValueObjectsFactoryClassName;
    }

    @Override
    public void setValueObjectsFactoryClassName(String valueObjectsFactoryClassName) {
        this.mValueObjectsFactoryClassName = valueObjectsFactoryClassName;
    }
}

