/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.transform.AbstractTransformer;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IJavaToHostTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJavaToHostTransformer
extends AbstractTransformer
implements IJavaToHostTransformer {
    private static final int MAX_HOST_DATA_SIZE = 0x7FFFFFF;
    private final Log _log = LogFactory.getLog(AbstractJavaToHostTransformer.class);

    public AbstractJavaToHostTransformer() {
    }

    public AbstractJavaToHostTransformer(String hostCharset) {
        super(hostCharset);
    }

    public AbstractJavaToHostTransformer(CobolContext cobolContext) {
        super(cobolContext);
    }

    public byte[] transform(Object valueObject, String hostCharset) throws HostTransformException {
        return this.transform(valueObject, hostCharset, new HostTransformStatus());
    }

    public byte[] transform(Object valueObject, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (hostCharset != null && hostCharset.length() > 0) {
            this.getCobolConverters().getCobolContext().setHostCharsetName(hostCharset);
        }
        return this.transform(valueObject, status);
    }

    public byte[] transform(Object valueObject) throws HostTransformException {
        return this.transform(valueObject, new HostTransformStatus());
    }

    public byte[] transform(Object valueObject, HostTransformStatus status) throws HostTransformException {
        long start = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Java to Host transformation started");
        }
        try {
            byte[] adjustedHostData;
            ICobolComplexBinding binding = this.getCachedBinding();
            binding.setObjectValue(valueObject);
            int size = binding.getByteLength();
            if (size > 0x7FFFFFF) {
                this._log.warn((Object)("Expected host data size of " + size + " exceeds the maximum allowed of " + 0x7FFFFFF));
                size = 0x7FFFFFF;
            }
            byte[] hostData = new byte[size];
            CobolElementVisitor marshaler = this.getCobolBindingVisitorsFactory().createMarshalVisitor(hostData, 0, this.getCobolConverters());
            binding.accept(marshaler);
            int bytesMarshalled = marshaler.getOffset();
            if (bytesMarshalled < size) {
                adjustedHostData = new byte[bytesMarshalled];
                System.arraycopy(hostData, 0, adjustedHostData, 0, bytesMarshalled);
            } else {
                adjustedHostData = hostData;
            }
            if (this._log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this._log.debug((Object)("Java to Host transformation ended. Processed: " + Integer.toString(bytesMarshalled) + " bytes " + "elapse:" + Long.toString(end - start) + " ms"));
            }
            status.setHostBytesProcessed(bytesMarshalled);
            status.setBinding(binding);
            return adjustedHostData;
        }
        catch (HostException he) {
            throw new HostTransformException(he);
        }
    }
}

