/*
 * Decompiled with CFR 0.152.
 */
package com.lemonappdev.konsist.core.util;

import com.lemonappdev.konsist.core.util.LocationUtilKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/lemonappdev/konsist/core/util/LocationUtil;", "", "()V", "REGEX_PACKAGE_NAME_END_TWO_DOTS", "", "resideInLocation", "", "desiredLocation", "currentLocation", "lib"})
@SourceDebugExtension(value={"SMAP\nLocationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationUtil.kt\ncom/lemonappdev/konsist/core/util/LocationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class LocationUtil {
    @NotNull
    public static final LocationUtil INSTANCE = new LocationUtil();
    @NotNull
    public static final String REGEX_PACKAGE_NAME_END_TWO_DOTS = "(?:^\\w+|\\w+\\.\\w+)+\\.{2}$";

    private LocationUtil() {
    }

    public final boolean resideInLocation(@NotNull String desiredLocation, @NotNull String currentLocation) {
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        if (!(((CharSequence)desiredLocation).length() > 0)) {
            boolean $i$a$-require-LocationUtil$resideInLocation$32 = false;
            String $i$a$-require-LocationUtil$resideInLocation$32 = "Location name is empty";
            throw new IllegalArgumentException($i$a$-require-LocationUtil$resideInLocation$32.toString());
        }
        if (!(!Intrinsics.areEqual((Object)desiredLocation, (Object)"."))) {
            boolean $i$a$-require-LocationUtil$resideInLocation$42 = false;
            String $i$a$-require-LocationUtil$resideInLocation$42 = "Incorrect location format: " + desiredLocation;
            throw new IllegalArgumentException($i$a$-require-LocationUtil$resideInLocation$42.toString());
        }
        if (Intrinsics.areEqual((Object)desiredLocation, (Object)"..")) {
            return true;
        }
        String string = desiredLocation.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String desiredPackageRegexString = LocationUtilKt.access$toPackageRegex(LocationUtilKt.access$toDotSeparatedLocation(string));
        String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)LocationUtilKt.access$toDotSeparatedLocation(currentLocation), (CharSequence)"."), (CharSequence)".").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String currentLocationCanonical = string2;
        CharSequence charSequence = currentLocationCanonical;
        return new Regex(desiredPackageRegexString).matches(charSequence);
    }
}

