/*
 * Decompiled with CFR 0.152.
 */
package com.lemonappdev.konsist.api.architecture;

import com.lemonappdev.konsist.core.exception.KoPreconditionFailedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\nJ\u000e\u0010\u000b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/lemonappdev/konsist/api/architecture/Layer;", "", "name", "", "definedBy", "(Ljava/lang/String;Ljava/lang/String;)V", "getDefinedBy$lib", "()Ljava/lang/String;", "getName$lib", "component1", "component1$lib", "component2", "component2$lib", "copy", "equals", "", "other", "hashCode", "", "toString", "lib"})
public final class Layer {
    @NotNull
    private final String name;
    @NotNull
    private final String definedBy;

    public Layer(@NotNull String name2, @NotNull String definedBy) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)definedBy, (String)"definedBy");
        this.name = name2;
        this.definedBy = definedBy;
        Regex pattern = new Regex(".*\\w+\\.{2}$");
        Regex twoDotsAtTheEndPattern = new Regex(".*\\w+\\.{2}$");
        Regex withoutSingleDotAtTheBeginningPattern = new Regex("^(?:\\w|\\.{2}\\w).*");
        Regex withoutFewDotsInOnePlacePattern = new Regex("(?:\\w+|\\.{2}\\w+)(?:\\.{0,2}\\w+)+\\.{2}$");
        if (!pattern.matches((CharSequence)this.definedBy)) {
            if (!withoutSingleDotAtTheBeginningPattern.matches((CharSequence)this.definedBy)) {
                throw new KoPreconditionFailedException("Layer " + this.name + " cannot be defined by a package starting with a single dot. Now: " + this.definedBy + " .", null, 2, null);
            }
            if (!twoDotsAtTheEndPattern.matches((CharSequence)this.definedBy)) {
                throw new KoPreconditionFailedException("Layer " + this.name + " must be defined by package ending with '..'. Now: " + this.definedBy + " .", null, 2, null);
            }
            if (!withoutFewDotsInOnePlacePattern.matches((CharSequence)this.definedBy)) {
                throw new KoPreconditionFailedException("Layer " + this.name + " cannot be defined by a package containing more than two dots in one place. Now: " + this.definedBy + " .", null, 2, null);
            }
        }
    }

    @NotNull
    public final String getName$lib() {
        return this.name;
    }

    @NotNull
    public final String getDefinedBy$lib() {
        return this.definedBy;
    }

    @NotNull
    public final String component1$lib() {
        return this.name;
    }

    @NotNull
    public final String component2$lib() {
        return this.definedBy;
    }

    @NotNull
    public final Layer copy(@NotNull String name2, @NotNull String definedBy) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)definedBy, (String)"definedBy");
        return new Layer(name2, definedBy);
    }

    public static /* synthetic */ Layer copy$default(Layer layer, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = layer.name;
        }
        if ((n & 2) != 0) {
            string2 = layer.definedBy;
        }
        return layer.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Layer(name=" + this.name + ", definedBy=" + this.definedBy + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.definedBy.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)layer.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.definedBy, (Object)layer.definedBy);
    }
}

