/*
 * Decompiled with CFR 0.152.
 */
package com.lemonappdev.konsist.api.architecture;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0002J\u000e\u0010\n\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/lemonappdev/konsist/api/architecture/Layer;", "", "name", "", "rootPackage", "(Ljava/lang/String;Ljava/lang/String;)V", "getName$lib", "()Ljava/lang/String;", "getRootPackage$lib", "buildPackageErrorMessage", "component1", "component1$lib", "component2", "component2$lib", "copy", "endsWithExactlyTwoDots", "", "equals", "other", "hashCode", "", "toString", "validatePackageDefinition", "", "Companion", "lib"})
@SourceDebugExtension(value={"SMAP\nLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Layer.kt\ncom/lemonappdev/konsist/api/architecture/Layer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n774#3:127\n865#3,2:128\n1872#3,3:130\n*S KotlinDebug\n*F\n+ 1 Layer.kt\ncom/lemonappdev/konsist/api/architecture/Layer\n*L\n94#1:127\n94#1:128,2\n97#1:130,3\n*E\n"})
public final class Layer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String rootPackage;
    @NotNull
    private static final Regex REGEX_VALID_PACKAGE_SEGMENT = new Regex("^[a-z][a-zA-Z0-9_]*$");

    public Layer(@NotNull String name2, @NotNull String rootPackage) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rootPackage, (String)"rootPackage");
        this.name = name2;
        this.rootPackage = rootPackage;
        if (!(!StringsKt.isBlank((CharSequence)this.name))) {
            boolean $i$a$-require-Layer$32 = false;
            String $i$a$-require-Layer$32 = "name is blank";
            throw new IllegalArgumentException($i$a$-require-Layer$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.rootPackage))) {
            boolean bl = false;
            String string = "rootPackage is blank";
            throw new IllegalArgumentException(string.toString());
        }
        this.validatePackageDefinition();
    }

    @NotNull
    public final String getName$lib() {
        return this.name;
    }

    @NotNull
    public final String getRootPackage$lib() {
        return this.rootPackage;
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePackageDefinition() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String effectivePackage;
        String string;
        if (Intrinsics.areEqual((Object)this.rootPackage, (Object)"..")) {
            throw new IllegalArgumentException("Invalid rootPackage definition for layer '" + this.name + "'. Package name cannot be empty. Current definition: " + this.rootPackage);
        }
        if (!this.endsWithExactlyTwoDots()) {
            throw new IllegalArgumentException(this.buildPackageErrorMessage());
        }
        String packageWithoutEndingDots = StringsKt.removeSuffix((String)this.rootPackage, (CharSequence)"..");
        if (((CharSequence)packageWithoutEndingDots).length() == 0) {
            throw new IllegalArgumentException("Invalid package definition for layer '" + this.name + "'. Package name cannot be empty. Current definition: " + this.rootPackage);
        }
        if (StringsKt.startsWith$default((String)packageWithoutEndingDots, (String)"..", (boolean)false, (int)2, null)) {
            String string2 = packageWithoutEndingDots.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = effectivePackage = packageWithoutEndingDots;
        }
        if (StringsKt.startsWith$default((String)effectivePackage, (String)".", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)packageWithoutEndingDots, (String)"..", (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Invalid package definition for layer '" + this.name + "'. Package cannot start with a dot. Current definition: " + this.rootPackage);
        }
        Object object = new String[]{"."};
        object = StringsKt.split$default((CharSequence)effectivePackage, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List segments = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (REGEX_VALID_PACKAGE_SEGMENT.matches((CharSequence)segment)) continue;
            throw new IllegalArgumentException("Invalid package definition for layer '" + this.name + "'. Invalid package segment '" + (String)segment + "' at position " + (index + 1) + ". Package segments must start with a lowercase letter and contain only letters, numbers, or underscores. Current definition: " + this.rootPackage);
        }
    }

    private final boolean endsWithExactlyTwoDots() {
        int lastIndex = this.rootPackage.length() - 1;
        return lastIndex >= 1 && this.rootPackage.charAt(lastIndex) == '.' && this.rootPackage.charAt(lastIndex - 1) == '.' && (lastIndex < 2 || this.rootPackage.charAt(lastIndex - 2) != '.');
    }

    private final String buildPackageErrorMessage() {
        return "Invalid package definition for layer '" + this.name + "'. To include subpackages, the definition must end with '..'. Current definition: " + this.rootPackage;
    }

    @NotNull
    public final String component1$lib() {
        return this.name;
    }

    @NotNull
    public final String component2$lib() {
        return this.rootPackage;
    }

    @NotNull
    public final Layer copy(@NotNull String name2, @NotNull String rootPackage) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rootPackage, (String)"rootPackage");
        return new Layer(name2, rootPackage);
    }

    public static /* synthetic */ Layer copy$default(Layer layer, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = layer.name;
        }
        if ((n & 2) != 0) {
            string2 = layer.rootPackage;
        }
        return layer.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Layer(name=" + this.name + ", rootPackage=" + this.rootPackage + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.rootPackage.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Layer)) {
            return false;
        }
        Layer layer = (Layer)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)layer.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.rootPackage, (Object)layer.rootPackage);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/lemonappdev/konsist/api/architecture/Layer$Companion;", "", "()V", "REGEX_VALID_PACKAGE_SEGMENT", "Lkotlin/text/Regex;", "lib"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

