/*
 * Decompiled with CFR 0.152.
 */
package com.lemonappdev.konsist.core.architecture.validator.rule;

import com.lemonappdev.konsist.api.architecture.Layer;
import com.lemonappdev.konsist.core.architecture.LayerDependency;
import com.lemonappdev.konsist.core.architecture.LayerDependencyType;
import com.lemonappdev.konsist.core.architecture.validator.rule.CircularDependencyDependenciesRule;
import com.lemonappdev.konsist.core.architecture.validator.rule.LayerDependenciesRule;
import com.lemonappdev.konsist.core.exception.KoInternalException;
import com.lemonappdev.konsist.core.exception.KoPreconditionFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004H\u0002JN\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002JF\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0016\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0016\u00a8\u0006 "}, d2={"Lcom/lemonappdev/konsist/core/architecture/validator/rule/CircularDependencyDependenciesRule;", "Lcom/lemonappdev/konsist/core/architecture/validator/rule/LayerDependenciesRule;", "()V", "buildDependencyGraph", "", "Lcom/lemonappdev/konsist/api/architecture/Layer;", "", "dependencies", "Lcom/lemonappdev/konsist/core/architecture/LayerDependency;", "findCycle", "", "start", "graph", "findCycleDFS", "", "current", "target", "path", "", "visited", "", "formatCircularDependencyMessage", "", "cycle", "hasCycle", "layer", "recursionStack", "requireNoCircularDependencies", "", "validate", "layerDependencies", "Companion", "lib"})
@SourceDebugExtension(value={"SMAP\nCircularDependencyDependenciesRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircularDependencyDependenciesRule.kt\ncom/lemonappdev/konsist/core/architecture/validator/rule/CircularDependencyDependenciesRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1863#2,2:122\n774#2:124\n865#2,2:125\n1485#2:127\n1510#2,3:128\n1513#2,3:138\n1246#2,2:143\n1611#2,9:145\n1863#2:154\n1864#2:156\n1620#2:157\n1249#2:158\n1863#2,2:159\n1863#2,2:161\n381#3,7:131\n462#3:141\n412#3:142\n1#4:155\n*S KotlinDebug\n*F\n+ 1 CircularDependencyDependenciesRule.kt\ncom/lemonappdev/konsist/core/architecture/validator/rule/CircularDependencyDependenciesRule\n*L\n19#1:122,2\n29#1:124\n29#1:125,2\n30#1:127\n30#1:128,3\n30#1:138,3\n31#1:143,2\n31#1:145,9\n31#1:154\n31#1:156\n31#1:157\n31#1:158\n50#1:159,2\n80#1:161,2\n30#1:131,7\n31#1:141\n31#1:142\n31#1:155\n*E\n"})
public final class CircularDependencyDependenciesRule
implements LayerDependenciesRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MINIMUM_CYCLE_SIZE = 2;
    private static final int DIRECT_CIRCULAR_DEPENDENCY_SIZE = 3;

    @Override
    public void validate(@NotNull Set<LayerDependency> layerDependencies) {
        Intrinsics.checkNotNullParameter(layerDependencies, (String)"layerDependencies");
        this.requireNoCircularDependencies(layerDependencies);
    }

    private final void requireNoCircularDependencies(Set<LayerDependency> dependencies) {
        Map<Layer, Set<Layer>> dependencyGraph = this.buildDependencyGraph(dependencies);
        Set visited = new LinkedHashSet();
        Set recursionStack = new LinkedHashSet();
        Iterable $this$forEach$iv = dependencyGraph.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Layer layer = (Layer)element$iv;
            boolean bl = false;
            if (visited.contains(layer) || !this.hasCycle(layer, dependencyGraph, visited, recursionStack)) continue;
            List<Layer> cycle = this.findCycle(layer, dependencyGraph);
            throw new KoPreconditionFailedException(this.formatCircularDependencyMessage(cycle), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Layer, Set<Layer>> buildDependencyGraph(Set<LayerDependency> dependencies) {
        void $this$mapValuesTo$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        LayerDependency it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LayerDependency)element$iv$iv;
            boolean bl = false;
            if (!(it.getDependencyType() == LayerDependencyType.DEPENDS_ON_LAYER && it.getLayer2() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (LayerDependency)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getLayer1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            List deps = (List)entry.getValue();
            Iterable $this$mapNotNull$iv = deps;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Layer it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl4 = false;
                LayerDependency it2 = (LayerDependency)element$iv$iv;
                boolean bl5 = false;
                if (it2.getLayer2() == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            object2.put(k, set);
        }
        return destination$iv$iv;
    }

    private final boolean hasCycle(Layer layer, Map<Layer, ? extends Set<Layer>> graph, Set<Layer> visited, Set<Layer> recursionStack) {
        if (recursionStack.contains(layer)) {
            return true;
        }
        if (visited.contains(layer)) {
            return false;
        }
        visited.add(layer);
        recursionStack.add(layer);
        Set<Layer> set = graph.get(layer);
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Layer dependentLayer = (Layer)element$iv;
                boolean bl = false;
                if (!this.hasCycle(dependentLayer, graph, visited, recursionStack)) continue;
                return true;
            }
        }
        recursionStack.remove(layer);
        return false;
    }

    private final List<Layer> findCycle(Layer start, Map<Layer, ? extends Set<Layer>> graph) {
        List path2 = new ArrayList();
        Set visited = new LinkedHashSet();
        this.findCycleDFS(start, start, graph, path2, visited);
        return path2;
    }

    private final boolean findCycleDFS(Layer current, Layer target, Map<Layer, ? extends Set<Layer>> graph, List<Layer> path2, Set<Layer> visited) {
        path2.add(current);
        visited.add(current);
        Set<Layer> set = graph.get(current);
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Layer next = (Layer)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)next, (Object)target) && path2.size() > 1) {
                    path2.add(next);
                    return true;
                }
                if (visited.contains(next) || !this.findCycleDFS(next, target, graph, path2, visited)) continue;
                return true;
            }
        }
        path2.remove(CollectionsKt.getLastIndex(path2));
        return false;
    }

    private final String formatCircularDependencyMessage(List<Layer> cycle) {
        String string;
        if (cycle.size() < 2) {
            throw new KoInternalException("Cycle must have at least 2 layers.", null, null, 6, null);
        }
        if (cycle.size() == 3) {
            string = "Circular dependency detected: '" + cycle.get(0).getName$lib() + "' <-> '" + cycle.get(1).getName$lib() + "'.";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$formatCircularDependencyMessage_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$formatCircularDependencyMessage_u24lambda_u247.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(cycle, (int)1), (CharSequence)" -> ", null, null, (int)0, null, (Function1)formatCircularDependencyMessage.cycleString.1.1.INSTANCE, (int)30, null));
            $this$formatCircularDependencyMessage_u24lambda_u247.append(" -> '" + cycle.get(0).getName$lib() + '\'');
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String cycleString2 = string2;
            string = "Circular dependency detected: " + cycleString2 + '.';
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/lemonappdev/konsist/core/architecture/validator/rule/CircularDependencyDependenciesRule$Companion;", "", "()V", "DIRECT_CIRCULAR_DEPENDENCY_SIZE", "", "MINIMUM_CYCLE_SIZE", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

