/*
 * Decompiled with CFR 0.152.
 */
package com.lemonappdev.konsist.core.architecture.validator.rule;

import com.lemonappdev.konsist.api.architecture.Layer;
import com.lemonappdev.konsist.core.architecture.LayerDependency;
import com.lemonappdev.konsist.core.architecture.validator.ascii.AsciiTreeCreator;
import com.lemonappdev.konsist.core.architecture.validator.ascii.AsciiTreeNode;
import com.lemonappdev.konsist.core.architecture.validator.ascii.AsciiTreeNodeFactory;
import com.lemonappdev.konsist.core.architecture.validator.rule.LayerDependenciesRule;
import com.lemonappdev.konsist.core.exception.KoPreconditionFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/lemonappdev/konsist/core/architecture/validator/rule/UniqueLayerRule;", "Lcom/lemonappdev/konsist/core/architecture/validator/rule/LayerDependenciesRule;", "asciiTreeCreator", "Lcom/lemonappdev/konsist/core/architecture/validator/ascii/AsciiTreeCreator;", "asciiTreeNodeFactory", "Lcom/lemonappdev/konsist/core/architecture/validator/ascii/AsciiTreeNodeFactory;", "(Lcom/lemonappdev/konsist/core/architecture/validator/ascii/AsciiTreeCreator;Lcom/lemonappdev/konsist/core/architecture/validator/ascii/AsciiTreeNodeFactory;)V", "extractLayers", "", "Lcom/lemonappdev/konsist/api/architecture/Layer;", "dependencies", "", "Lcom/lemonappdev/konsist/core/architecture/LayerDependency;", "requireUniqueLayers", "", "layers", "validate", "lib"})
@SourceDebugExtension(value={"SMAP\nUniqueLayerRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueLayerRule.kt\ncom/lemonappdev/konsist/core/architecture/validator/rule/UniqueLayerRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1368#2:51\n1454#2,5:52\n1663#2,8:57\n1863#2,2:65\n1557#2:67\n1628#2,3:68\n*S KotlinDebug\n*F\n+ 1 UniqueLayerRule.kt\ncom/lemonappdev/konsist/core/architecture/validator/rule/UniqueLayerRule\n*L\n20#1:51\n20#1:52,5\n21#1:57,8\n29#1:65,2\n42#1:67\n42#1:68,3\n*E\n"})
public final class UniqueLayerRule
implements LayerDependenciesRule {
    @NotNull
    private final AsciiTreeCreator asciiTreeCreator;
    @NotNull
    private final AsciiTreeNodeFactory asciiTreeNodeFactory;

    public UniqueLayerRule(@NotNull AsciiTreeCreator asciiTreeCreator, @NotNull AsciiTreeNodeFactory asciiTreeNodeFactory) {
        Intrinsics.checkNotNullParameter((Object)asciiTreeCreator, (String)"asciiTreeCreator");
        Intrinsics.checkNotNullParameter((Object)asciiTreeNodeFactory, (String)"asciiTreeNodeFactory");
        this.asciiTreeCreator = asciiTreeCreator;
        this.asciiTreeNodeFactory = asciiTreeNodeFactory;
    }

    public /* synthetic */ UniqueLayerRule(AsciiTreeCreator asciiTreeCreator, AsciiTreeNodeFactory asciiTreeNodeFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            asciiTreeCreator = new AsciiTreeCreator();
        }
        if ((n & 2) != 0) {
            asciiTreeNodeFactory = new AsciiTreeNodeFactory();
        }
        this(asciiTreeCreator, asciiTreeNodeFactory);
    }

    @Override
    public void validate(@NotNull Set<LayerDependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        List<Layer> layers = this.extractLayers(dependencies);
        this.requireUniqueLayers(layers);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Layer> extractLayers(Set<LayerDependency> dependencies) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = dependencies;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LayerDependency it = (LayerDependency)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Layer[]{it.getLayer1(), it.getLayer2()};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Layer it = (Layer)e$iv;
            boolean bl = false;
            Integer key$iv = System.identityHashCode(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void requireUniqueLayers(List<Layer> layers) {
        Object layer;
        List nameViolations = new ArrayList();
        List packageViolations = new ArrayList();
        Set seenNames = new LinkedHashSet();
        Set seenPackages = new LinkedHashSet();
        Iterable $this$forEach$iv = layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            layer = (Layer)element$iv;
            boolean bl = false;
            if (!seenNames.add(((Layer)layer).getName$lib())) {
                nameViolations.add("Layer name must be unique. Duplicated name: '" + ((Layer)layer).getName$lib() + "'.");
            }
            if (seenPackages.add(((Layer)layer).getRootPackage$lib())) continue;
            packageViolations.add("Layer rootPackage must be unique. Duplicated rootPackage: '" + ((Layer)layer).getRootPackage$lib() + "'.");
        }
        List violations2 = CollectionsKt.plus((Collection)nameViolations, (Iterable)packageViolations);
        if (!((Collection)violations2).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = violations2;
            boolean $i$f$map = false;
            layer = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AsciiTreeNodeFactory.create$default(this.asciiTreeNodeFactory, (String)it, null, 2, null));
            }
            List violationNodes = (List)destination$iv$iv;
            AsciiTreeNode asciiTreeRootNode = this.asciiTreeNodeFactory.create("Invalid layers configuration:", violationNodes);
            String errorMessage = AsciiTreeCreator.invoke$default(this.asciiTreeCreator, asciiTreeRootNode, null, 2, null);
            throw new KoPreconditionFailedException(errorMessage, null, 2, null);
        }
    }

    public UniqueLayerRule() {
        this(null, null, 3, null);
    }
}

