/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.Violation;
import com.lewisd.maven.lint.ViolationSuppressor;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class ResultCollectorImpl
implements ResultCollector {
    private final List<Violation> violations = new LinkedList<Violation>();
    private final ViolationSuppressor violationSuppressor;

    @Autowired
    public ResultCollectorImpl(ViolationSuppressor violationSuppressor) {
        this.violationSuppressor = violationSuppressor;
    }

    @Override
    public void addViolation(MavenProject mavenProject, Rule rule, String message, InputLocation inputLocation) {
        Violation violation = new Violation(mavenProject, rule, message, inputLocation);
        if (!this.violationSuppressor.isSuppressed(violation)) {
            this.violations.add(violation);
        }
    }

    @Override
    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }
}

