/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.model;

public class Coordinates {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String version;

    public Coordinates(String groupId, String artifactId) {
        this(groupId, artifactId, null, null);
    }

    public Coordinates(String groupId, String artifactId, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matches(Coordinates coords) {
        if (this.groupId != null && !this.groupId.equals(coords.getGroupId())) {
            return false;
        }
        if (this.artifactId != null && !this.artifactId.equals(coords.getArtifactId())) {
            return false;
        }
        if (this.type != null && !this.type.equals(coords.getType())) {
            return false;
        }
        return this.version == null || this.version.equals(coords.getVersion());
    }

    public static Coordinates parse(String coordinate) {
        String[] parts = coordinate.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        if (parts.length > 2) {
            throw new IllegalArgumentException("Coordinate format only supports groupId:artifactId");
        }
        return new Coordinates(groupId, artifactId);
    }
}

