/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.google.common.collect.Maps;
import com.lewisd.maven.lint.plugin.AbstractContextMojo;
import com.lewisd.maven.lint.rules.AbstractRule;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="list", threadSafe=true, requiresProject=true)
public class ListRulesMojo
extends AbstractContextMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        Collection rules = this.getContext().getBeansOfType(AbstractRule.class).values();
        TreeMap name2ruleMap = Maps.newTreeMap();
        for (AbstractRule rule : rules) {
            name2ruleMap.put(rule.getIdentifier(), rule);
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry entry : name2ruleMap.entrySet()) {
            AbstractRule rule = (AbstractRule)entry.getValue();
            buffer.append("- ").append(rule.getIdentifier()).append("\n\n").append(this.formatAsBlock(rule)).append("\n\n");
        }
        System.out.println(buffer.toString().replaceFirst("\n$", ""));
    }

    private String formatAsBlock(AbstractRule rule) {
        String description = rule.getDescription();
        String[] words = description.split("\\ +");
        StringBuilder lines = new StringBuilder("\t");
        int maxLength = 80;
        int count = 0;
        for (String word : words) {
            if (count + word.length() + 1 <= maxLength) {
                if (count > 0) {
                    lines.append(' ');
                    ++count;
                }
            } else {
                count = 0;
                lines.append("\n\t");
            }
            lines.append(word);
            count += word.length();
        }
        return lines.toString();
    }
}

