/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.report.xml;

import com.lewisd.maven.lint.Results;
import com.lewisd.maven.lint.Violation;
import com.lewisd.maven.lint.report.AbstractReportWriter;
import com.lewisd.maven.lint.report.xml.ResultsConvertor;
import com.lewisd.maven.lint.report.xml.ViolationConvertor;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class XmlResultWriter
extends AbstractReportWriter {
    @Override
    public void writeResults(MavenProject mavenProject, List<Violation> violations, File outputFile) {
        XStream xstream = new XStream();
        xstream.registerConverter((Converter)new ViolationConvertor());
        xstream.registerConverter((Converter)new ResultsConvertor());
        xstream.alias("results", Results.class);
        Results results = new Results(violations);
        FileWriter writer = null;
        try {
            writer = this.createOutputFileWriter(outputFile);
            xstream.toXML((Object)results, (Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing results to " + outputFile, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while trying to close file " + outputFile, e);
                }
            }
        }
    }
}

