/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class DuplicateDependenciesRule
extends AbstractRule {
    @Autowired
    public DuplicateDependenciesRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    @Override
    public String getIdentifier() {
        return "DuplicateDep";
    }

    @Override
    public String getDescription() {
        return "Multiple dependencies, in <dependencies> or <managedDependencies>, with the same co-ordinates are reduntant, and can be confusing.  If they have different versions, they can lead to unexpected behaviour.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Model originalModel = mavenProject.getOriginalModel();
        Collection<Dependency> dependencies = this.expressionEvaluator.getPath(originalModel, "dependencies");
        Collection<Dependency> managedDependencies = this.expressionEvaluator.getPath(originalModel, "dependencyManagement/dependencies");
        this.checkForDuplicateDependencies(mavenProject, resultCollector, dependencies, "Dependency");
        this.checkForDuplicateDependencies(mavenProject, resultCollector, managedDependencies, "Managed dependency");
    }

    private void checkForDuplicateDependencies(MavenProject mavenProject, ResultCollector resultCollector, Collection<Dependency> dependencies, String dependencyDescription) {
        LinkedList<Dependency> otherDependencies = new LinkedList<Dependency>(dependencies);
        for (Dependency dependency : dependencies) {
            this.checkForDuplicateArtifacts(mavenProject, resultCollector, dependency, otherDependencies, dependencyDescription);
        }
    }

    private void checkForDuplicateArtifacts(MavenProject mavenProject, ResultCollector resultCollector, Dependency dependency, Collection<Dependency> otherDependencies, String dependencyDescription) {
        Iterator<Dependency> i = otherDependencies.iterator();
        while (i.hasNext()) {
            Dependency otherManagedDependency = i.next();
            if (!otherManagedDependency.getManagementKey().equals(dependency.getManagementKey())) continue;
            i.remove();
            if (otherManagedDependency == dependency) continue;
            String version = this.modelUtil.getVersion(dependency);
            String otherVersion = this.modelUtil.getVersion(otherManagedDependency);
            InputLocation location = this.modelUtil.getLocation(dependency);
            InputLocation otherLocation = this.modelUtil.getLocation(otherManagedDependency);
            if (ObjectUtils.equals((Object)version, (Object)otherVersion)) {
                resultCollector.addViolation(mavenProject, this, dependencyDescription + " '" + this.modelUtil.getKey(dependency) + "' is declared multiple times with the same version: " + otherLocation.getLineNumber() + ":" + otherLocation.getColumnNumber(), location);
                continue;
            }
            resultCollector.addViolation(mavenProject, this, dependencyDescription + " '" + this.modelUtil.getKey(dependency) + "' is declared multiple times with different versions (" + version + ", " + otherVersion + ")", location);
        }
    }
}

