/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.model.ExtPlugin;
import com.lewisd.maven.lint.model.ObjectWithPath;
import com.lewisd.maven.lint.rules.AbstractReduntantVersionRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class RedundantPluginVersionsRule
extends AbstractReduntantVersionRule {
    @Autowired
    public RedundantPluginVersionsRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil, PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator) {
        super(expressionEvaluator, modelUtil, pluginParameterExpressionEvaluator);
    }

    @Override
    public String getIdentifier() {
        return "RedundantPluginVersion";
    }

    @Override
    public String getDescription() {
        return "Plugin versions should be set in one place, and not overridden without changing the version. If, for example, <pluginManagement> sets a version, and <plugins> somewhere overrides it, but with the same version, this can make version upgrades more difficult, due to the repetition.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Model originalModel = mavenProject.getOriginalModel();
        Collection plugins = this.expressionEvaluator.getPath(originalModel, "build/plugins");
        Collection<Plugin> managedPlugins = this.expressionEvaluator.getPath(originalModel, "build/pluginManagement/plugins");
        Map<String, Plugin> managedPluginsByManagementKey = this.modelUtil.mapById(managedPlugins);
        for (Plugin plugin : plugins) {
            Plugin managedDependency = managedPluginsByManagementKey.get(plugin.getId());
            if (managedDependency != null) {
                this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Plugin>(plugin, mavenProject, "build/plugins"), new ObjectWithPath<Plugin>(managedDependency, mavenProject, "build/pluginManagement/plugins"), "Plugin", "in pluginManagement");
            }
            List<ObjectWithPath<ExtPlugin>> inheritedPlugins = this.modelUtil.findInheritedPlugins(mavenProject, plugin);
            for (ObjectWithPath<ExtPlugin> inheritedPlugin : inheritedPlugins) {
                this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Plugin>(plugin, mavenProject, "build/plugins"), inheritedPlugin, "Plugin", "is inherited from " + inheritedPlugin.getProject().getId());
            }
        }
        for (Plugin managedPlugin : managedPlugins) {
            List<ObjectWithPath<ExtPlugin>> inheritedPlugins = this.modelUtil.findInheritedPlugins(mavenProject, managedPlugin);
            for (ObjectWithPath<ExtPlugin> inheritedPlugin : inheritedPlugins) {
                this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Plugin>(managedPlugin, mavenProject, "build/pluginManagement/plugins"), inheritedPlugin, "Managed plugin", "is inherited from " + inheritedPlugin.getProject().getId());
            }
        }
    }
}

