/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.aop;

import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.web.utils.JsonUtil;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class ControllerAspector {
    @Pointcut(value="(@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)) && execution(public * *(..))")
    public void controllerPointCut() {
    }

    @Around(value="controllerPointCut()")
    public Object logController(ProceedingJoinPoint joinPoint) throws Throwable {
        Logger logger = LoggerFactory.getLogger(joinPoint.getTarget().getClass());
        Object[] args = joinPoint.getArgs();
        LinkedList<Object> argList = new LinkedList<Object>();
        if (logger.isDebugEnabled()) {
            String logMsg;
            if (!ArrayUtil.isEmpty((Object[])args)) {
                for (Object arg : args) {
                    if (arg instanceof HttpServletRequest) {
                        argList.add("request");
                        continue;
                    }
                    if (arg instanceof HttpServletResponse) {
                        argList.add("response");
                        continue;
                    }
                    if (arg instanceof MultipartFile) {
                        argList.add("file");
                        continue;
                    }
                    argList.add(arg);
                }
                if (CollectionUtil.isEmpty(argList)) {
                    logMsg = "null";
                } else {
                    try {
                        logMsg = JsonUtil.toJsonString(argList);
                    }
                    catch (Exception e) {
                        logMsg = "unknown";
                    }
                }
            } else {
                logMsg = "null";
            }
            logger.debug("Controller={},method={},\u8bf7\u6c42\u53c2\u6570={}", new Object[]{joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), logMsg});
        } else {
            logger.info("Controller={},method={},\u5f00\u59cb\u8bf7\u6c42", (Object)joinPoint.getTarget().getClass().getName(), (Object)joinPoint.getSignature().getName());
        }
        long begTime = System.currentTimeMillis();
        Object value = joinPoint.proceed();
        long invokeTime = System.currentTimeMillis() - begTime;
        if (logger.isDebugEnabled()) {
            logger.debug("Controller={},method={},\u8fd4\u56de\u53c2\u6570={}", new Object[]{joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), JsonUtil.toJsonString(value)});
        } else {
            logger.info("Controller={},method={},\u54cd\u5e94\u6210\u529f", (Object)joinPoint.getTarget().getClass().getName(), (Object)joinPoint.getSignature().getName());
        }
        logger.info("Controller={},method={},\u54cd\u5e94\u65f6\u95f4={}ms", new Object[]{joinPoint.getTarget().getClass().getName(), joinPoint.getSignature().getName(), invokeTime});
        return value;
    }
}

