/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.aop;

import com.lframework.starter.common.exceptions.impl.AccessDeniedException;
import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.web.annotations.OpenApi;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.sign.CheckSignFactory;
import com.lframework.starter.web.sign.CheckSignHandler;
import com.lframework.starter.web.vo.OpenApiReqVo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class OpenApiAspect {
    @Pointcut(value="(@within(org.springframework.web.bind.annotation.RestController) || @within(org.springframework.stereotype.Controller)) && @annotation(com.lframework.starter.web.annotations.OpenApi) && execution(public * *(..))")
    public void openApiPointCut() {
    }

    @Around(value="openApiPointCut()")
    public Object openApi(ProceedingJoinPoint joinPoint) throws Throwable {
        Logger logger = LoggerFactory.getLogger(joinPoint.getTarget().getClass());
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        OpenApi openApi = signature.getMethod().getAnnotation(OpenApi.class);
        Object[] args = joinPoint.getArgs();
        CheckSignFactory checkSignFactory = (CheckSignFactory)ApplicationUtil.getBean(CheckSignFactory.class);
        CheckSignHandler checkSignHandler = checkSignFactory.getInstance();
        if (openApi.sign()) {
            if (ArrayUtil.isEmpty((Object[])args)) {
                throw new AccessDeniedException("\u9a8c\u7b7e\u5931\u8d25\uff01");
            }
            List reqList = Arrays.stream(args).filter(t -> t instanceof OpenApiReqVo).map(t -> (OpenApiReqVo)t).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(reqList)) {
                throw new AccessDeniedException("\u9a8c\u7b7e\u5931\u8d25\uff01");
            }
            for (OpenApiReqVo req : reqList) {
                if (!checkSignHandler.check(req)) {
                    throw new AccessDeniedException("\u9a8c\u7b7e\u5931\u8d25\uff01");
                }
                checkSignHandler.setTenantId(req);
            }
        }
        Object value = joinPoint.proceed();
        return value;
    }
}

