/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.aop;

import com.lframework.starter.common.exceptions.impl.AccessDeniedException;
import com.lframework.starter.web.annotations.security.HasPermission;
import com.lframework.starter.web.components.security.CheckPermissionHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class PermissionAspect {
    @Autowired
    private CheckPermissionHandler checkPermissionHandler;

    @Pointcut(value="@annotation(com.lframework.starter.web.annotations.security.HasPermission) && execution(public * *(..))")
    public void permissionPointCut() {
    }

    @Around(value="permissionPointCut()")
    public Object permission(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        HasPermission hasPermission = signature.getMethod().getAnnotation(HasPermission.class);
        if (!this.checkPermissionHandler.valid(hasPermission.calcType(), hasPermission.value())) {
            throw new AccessDeniedException("\u6682\u65e0\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        Object value = joinPoint.proceed();
        return value;
    }
}

