/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.excel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.AbstractCellStyleStrategy;
import com.lframework.starter.common.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelHorizontalCellStyleStrategy
extends AbstractCellStyleStrategy {
    private WriteCellStyle headWriteCellStyle;
    private WriteCellStyle requiredFieldHeadWriteCellStyle;
    private List<WriteCellStyle> contentWriteCellStyleList;
    private CellStyle headCellStyle;
    private CellStyle requiredFieldHeadCellStyle;
    private List<CellStyle> contentCellStyleList;
    private Set<String> requiredFiledNames;

    public ExcelHorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, WriteCellStyle requiredFieldHeadWriteCellStyle, List<WriteCellStyle> contentWriteCellStyleList, Set<String> requiredFiledNames) {
        this.headWriteCellStyle = headWriteCellStyle;
        this.requiredFieldHeadWriteCellStyle = requiredFieldHeadWriteCellStyle;
        this.contentWriteCellStyleList = contentWriteCellStyleList;
        this.requiredFiledNames = requiredFiledNames;
    }

    public ExcelHorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, WriteCellStyle requiredFieldHeadWriteCellStyle, WriteCellStyle contentWriteCellStyle, Set<String> requiredFiledNames) {
        this.headWriteCellStyle = headWriteCellStyle;
        this.requiredFieldHeadWriteCellStyle = requiredFieldHeadWriteCellStyle;
        this.contentWriteCellStyleList = new ArrayList<WriteCellStyle>();
        this.contentWriteCellStyleList.add(contentWriteCellStyle);
        this.requiredFiledNames = requiredFiledNames;
    }

    protected void initCellStyle(Workbook workbook) {
        if (this.headWriteCellStyle != null) {
            this.headCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)this.headWriteCellStyle);
        }
        if (this.headWriteCellStyle != null) {
            this.requiredFieldHeadCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)this.requiredFieldHeadWriteCellStyle);
        }
        if (this.contentWriteCellStyleList != null && !this.contentWriteCellStyleList.isEmpty()) {
            this.contentCellStyleList = new ArrayList<CellStyle>();
            for (WriteCellStyle writeCellStyle : this.contentWriteCellStyleList) {
                this.contentCellStyleList.add(StyleUtil.buildContentCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle));
            }
        }
    }

    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (this.headCellStyle == null) {
            return;
        }
        cell.setCellStyle(CollectionUtil.isNotEmpty(this.requiredFiledNames) && this.requiredFiledNames.contains(head.getFieldName()) ? this.requiredFieldHeadCellStyle : this.headCellStyle);
    }

    protected void setContentCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (this.contentCellStyleList == null || this.contentCellStyleList.isEmpty()) {
            return;
        }
        cell.setCellStyle(this.contentCellStyleList.get(relativeRowIndex % this.contentCellStyleList.size()));
    }
}

