/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.lframework.starter.common.exceptions.impl.DefaultClientException;
import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.NumberUtil;
import com.lframework.starter.common.utils.ReflectUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.annotations.excel.ExcelRequired;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.components.excel.ExcelEventListener;
import com.lframework.starter.web.components.excel.ExcelModel;
import com.lframework.starter.web.service.SysParameterService;
import com.lframework.starter.web.utils.ExcelImportUtil;
import com.lframework.starter.web.utils.TransactionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public abstract class ExcelImportListener<T extends ExcelModel>
extends ExcelEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportListener.class);
    private final SysParameterService sysParameterService = (SysParameterService)ApplicationUtil.getBean(SysParameterService.class);
    protected List<T> datas = new ArrayList<T>();
    protected int totalRows;
    protected String taskId;
    private Integer limitRows;
    private int currentRows;
    private boolean hasError;
    private boolean interrupt;

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.totalRows = Math.max(0, context.readSheetHolder().getApproximateTotalRowNumber() - 1);
        if (this.limitRows == null) {
            this.limitRows = Integer.valueOf(this.sysParameterService.findRequiredByKey("excel-import.max-size"));
        }
        if (this.totalRows == 0) {
            this.interrupt = true;
            throw new DefaultClientException("\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (this.totalRows > this.limitRows) {
            this.interrupt = true;
            throw new DefaultClientException("\u4e00\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u5165" + this.limitRows + "\u6761");
        }
        Class clazz = context.readWorkbookHolder().getClazz();
        if (clazz != null) {
            this.checkHeadMap(headMap, clazz);
        }
        this.doInvokeHeadMap(headMap, context);
    }

    protected void checkHeadMap(Map<Integer, String> headMap, Class<T> clazz) {
        int i;
        ArrayList<String> fieldNameList = new ArrayList<String>();
        Field[] fields = ReflectUtil.getFields(clazz);
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            String headerName = ArrayUtil.isEmpty((Object[])excelProperty.value()) ? null : excelProperty.value()[0];
            fieldNameList.add(headerName);
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            String fieldName = (String)fieldNameList.get(i);
            if (StringUtil.equals((CharSequence)fieldName, (CharSequence)headMap.get(i))) continue;
            throw new DefaultClientException("\u7b2c" + (i + 1) + "\u5217\u5e94\u4e3a\u3010" + fieldName + "\u3011\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6");
        }
    }

    protected void doInvokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
    }

    public void invoke(T data, AnalysisContext context) {
        if (this.interrupt) {
            return;
        }
        ++this.currentRows;
        this.setProcess(this.totalRows == 0 ? 100 : Math.min(NumberUtil.mul((Number[])new Number[]{NumberUtil.div((Number)this.currentRows, (Number[])new Number[]{this.totalRows}), 100}).intValue(), 100));
        if (!this.hasError) {
            this.datas.add(data);
            this.checkFields(data);
            this.doInvoke(data, context);
        }
    }

    private void checkFields(T data) {
        if (data == null) {
            return;
        }
        Field[] fields = ReflectUtil.getFields(data.getClass());
        int index = 0;
        for (Field field : fields) {
            Object val;
            ExcelIgnore excelIgnore;
            ++index;
            ExcelRequired excelRequired = field.getAnnotation(ExcelRequired.class);
            if (excelRequired == null || (excelIgnore = field.getAnnotation(ExcelIgnore.class)) != null || (val = ReflectUtil.getFieldValue(data, (Field)field)) != null && (!(val instanceof CharSequence) || !StringUtil.isEmpty((CharSequence)((CharSequence)val)))) continue;
            String fieldName = null;
            fieldName = field.getName();
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty != null) {
                Object[] fieldNames = excelProperty.value();
                fieldName = ArrayUtil.join((Object[])fieldNames, (CharSequence)"-");
            }
            throw new DefaultClientException("\u7b2c" + index + "\u884c\u201c" + fieldName + "\u201d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected abstract void doInvoke(T var1, AnalysisContext var2);

    protected void setProcess(Integer process) {
        ExcelImportUtil.setProcess(this.taskId, process);
    }

    protected void setSuccessProcess(Integer process) {
        ExcelImportUtil.setSuccessProcess(this.taskId, process);
    }

    protected void setSuccessProcessByIndex(Integer curIndex) {
        this.setSuccessProcess(this.totalRows == 0 ? 100 : Math.min(NumberUtil.mul((Number[])new Number[]{NumberUtil.div((Number)(curIndex + 1), (Number[])new Number[]{this.totalRows}), 100}).intValue(), 100));
    }

    protected boolean addTipMsg(String msg) {
        if (StringUtil.isBlank((CharSequence)msg)) {
            return true;
        }
        return ExcelImportUtil.addTipMsg(this.taskId, msg);
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        log.error(exception.getMessage(), (Throwable)exception);
        if (!this.addTipMsg(exception.getMessage())) {
            this.interrupt = true;
        }
        this.hasError = true;
        ExcelImportUtil.setHasError(this.taskId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAfterAllAnalysed(AnalysisContext context) {
        try {
            if (this.hasError || this.interrupt) {
                return;
            }
            this.setProcess(100);
            if (this.requireTransaction()) {
                TransactionStatus transactionStatus = TransactionUtil.getTransaction();
                try {
                    this.afterAllAnalysed(context);
                    TransactionUtil.commit(transactionStatus);
                }
                catch (Throwable throwable) {
                    TransactionUtil.rollback(transactionStatus);
                    if (throwable instanceof Exception) {
                        try {
                            this.onException((Exception)throwable, context);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    throw throwable;
                }
            }
            this.afterAllAnalysed(context);
            try {
                this.doComplete();
            }
            catch (Exception e) {
                try {
                    this.onException(e, context);
                }
                catch (Exception ex) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            ExcelImportUtil.finished(this.taskId);
        }
    }

    protected boolean requireTransaction() {
        return true;
    }

    protected abstract void afterAllAnalysed(AnalysisContext var1);

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        ExcelImportUtil.initUploadTask(taskId);
    }

    protected abstract void doComplete();

    public List<T> getDatas() {
        return this.datas;
    }
}

