/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.excel;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.builder.AbstractExcelWriterParameterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.lframework.starter.common.utils.BeanUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.web.utils.ExcelUtil;
import java.util.Collection;
import java.util.List;

public class ExcelMultipartWriterSheetBuilder
extends AbstractExcelWriterParameterBuilder<ExcelMultipartWriterSheetBuilder, WriteSheet> {
    private static final int MAX_ROW_COUNT = 65535;
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet = new WriteSheet();
    private int totalRowCount = 0;
    private int currentSheetNo = 0;
    private int maxRowCount = 65535;

    public ExcelMultipartWriterSheetBuilder() {
    }

    public ExcelMultipartWriterSheetBuilder(ExcelWriter excelWriter) {
        this.excelWriter = excelWriter;
    }

    public ExcelMultipartWriterSheetBuilder sheetNo(Integer sheetNo) {
        this.writeSheet.setSheetNo(sheetNo);
        this.currentSheetNo = sheetNo;
        return this;
    }

    public ExcelMultipartWriterSheetBuilder sheetName(String sheetName) {
        this.writeSheet.setSheetName(sheetName);
        return this;
    }

    public WriteSheet build() {
        return this.writeSheet;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public void doWrite(List data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet()' to call this method");
        }
        if (!CollectionUtil.isEmpty((Collection)data)) {
            int remainRow = this.maxRowCount - this.totalRowCount;
            if (remainRow < data.size()) {
                if (remainRow > 0) {
                    this.doWrite(data.subList(0, remainRow));
                    this.nextSheet();
                    this.doWrite(data.subList(remainRow, data.size()));
                } else {
                    this.nextSheet();
                    this.doWrite(data);
                }
            } else {
                this.totalRowCount += data.size();
                this.excelWriter.write(data, this.build());
            }
        } else {
            this.excelWriter.write(data, this.build());
        }
    }

    public void nextSheet() {
        ++this.currentSheetNo;
        WriteSheet writeSheet = new WriteSheet();
        BeanUtil.copyProperties((Object)this.writeSheet, (Object)writeSheet, (String[])new String[0]);
        writeSheet.setSheetNo(Integer.valueOf(this.currentSheetNo));
        writeSheet.setSheetName(this.writeSheet.getSheetName() + this.currentSheetNo);
        writeSheet.setCustomWriteHandlerList(ExcelUtil.getWriteHandlers());
        this.writeSheet = writeSheet;
        this.totalRowCount = 0;
    }

    public void finish() {
        if (this.excelWriter != null) {
            this.excelWriter.finish();
        }
    }

    protected WriteSheet parameter() {
        return this.writeSheet;
    }
}

