/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.generator;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.components.generator.handler.GenerateCodeRuleHandler;
import com.lframework.starter.web.components.generator.rule.GenerateCodeRule;
import com.lframework.starter.web.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GenerateCodeFactory {
    public static String generate(String configStr) {
        return GenerateCodeFactory.generate(GenerateCodeFactory.getRules(configStr));
    }

    public static String generate(List<GenerateCodeRule> ruleList) {
        Map handlerMap = ApplicationUtil.getBeansOfType(GenerateCodeRuleHandler.class);
        Collection handlerList = handlerMap.values();
        StringBuilder builder = new StringBuilder();
        for (GenerateCodeRule rule : ruleList) {
            for (GenerateCodeRuleHandler handler : handlerList) {
                if (!handler.match(rule)) continue;
                builder.append(handler.generate(rule));
            }
        }
        return builder.toString();
    }

    public static String generateExample(String configStr) {
        return GenerateCodeFactory.generateExample(GenerateCodeFactory.getRules(configStr));
    }

    public static String generateExample(List<GenerateCodeRule> ruleList) {
        Map handlerMap = ApplicationUtil.getBeansOfType(GenerateCodeRuleHandler.class);
        Collection handlerList = handlerMap.values();
        StringBuilder builder = new StringBuilder();
        for (GenerateCodeRule rule : ruleList) {
            for (GenerateCodeRuleHandler handler : handlerList) {
                if (!handler.match(rule)) continue;
                builder.append(handler.generateExample(rule));
            }
        }
        return builder.toString();
    }

    public static List<GenerateCodeRuleHandler> getHandlers(String configStr) {
        Map handlerMap = ApplicationUtil.getBeansOfType(GenerateCodeRuleHandler.class);
        JSONArray configArr = JsonUtil.parseArray((String)configStr);
        ArrayList<GenerateCodeRuleHandler> results = new ArrayList<GenerateCodeRuleHandler>();
        for (int i = 0; i < configArr.size(); ++i) {
            JSONObject config = configArr.getJSONObject((Object)i);
            Integer type = config.getInt((Object)"type");
            if (type == null) {
                throw new DefaultSysException("configStr {} \u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01");
            }
            Collection handlerList = handlerMap.values();
            for (GenerateCodeRuleHandler handler : handlerList) {
                if (!handler.match(type)) continue;
                results.add(handler);
            }
        }
        if (results.isEmpty()) {
            throw new DefaultSysException("configStr {} \u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01");
        }
        return results;
    }

    public static List<GenerateCodeRule> getRules(String configStr) {
        List<GenerateCodeRuleHandler> ruleHandlerList = GenerateCodeFactory.getHandlers(configStr);
        JSONArray configArr = JsonUtil.parseArray((String)configStr);
        ArrayList<GenerateCodeRule> results = new ArrayList<GenerateCodeRule>();
        for (int i = 0; i < ruleHandlerList.size(); ++i) {
            GenerateCodeRuleHandler ruleHandler = ruleHandlerList.get(i);
            results.add((GenerateCodeRule)ruleHandler.parseRule(configArr.getStr((Object)i)));
        }
        return results;
    }
}

