/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.generator.handler.impl;

import com.lframework.starter.common.exceptions.impl.DefaultClientException;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.locker.LockBuilder;
import com.lframework.starter.common.locker.Locker;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.common.tenant.TenantContextHolder;
import com.lframework.starter.web.components.generator.handler.GenerateCodeRuleHandler;
import com.lframework.starter.web.components.generator.rule.GenerateCodeRule;
import com.lframework.starter.web.components.generator.rule.impl.FlowGenerateCodeRule;
import com.lframework.starter.web.components.redis.RedisHandler;
import com.lframework.starter.web.utils.IdUtil;
import com.lframework.starter.web.utils.JsonUtil;
import com.lframework.starter.web.utils.TenantUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowGenerateCodeRuleHandler
implements GenerateCodeRuleHandler<FlowGenerateCodeRule> {
    private static final String LOCK_KEY = "flow_generator_index_";
    @Autowired
    private RedisHandler redisHandler;
    @Autowired
    private LockBuilder lockBuilder;

    @Override
    public boolean match(Integer ruleType) {
        return ruleType != null && ruleType == 3;
    }

    @Override
    public boolean match(GenerateCodeRule rule) {
        return rule instanceof FlowGenerateCodeRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate(FlowGenerateCodeRule rule) {
        long no;
        Integer codeLen = rule.getLen() == null ? 1 : rule.getLen();
        String lockerName = LOCK_KEY + rule.getKey();
        String redisKey = lockerName + "_" + (TenantUtil.enableTenant() ? TenantContextHolder.getTenantId() : "noTenant");
        Locker locker = this.lockBuilder.buildLocker(redisKey + "_Locker", 60000L, 5000L);
        if (locker.lock()) {
            try {
                no = this.redisHandler.incr(redisKey, rule.getStep().intValue());
            }
            finally {
                locker.unLock();
            }
        } else {
            throw new DefaultClientException("\u751f\u6210\u5355\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        this.redisHandler.expire(redisKey, rule.getExpireSeconds() * 1000L);
        String noStr = String.valueOf(no);
        if (noStr.length() > codeLen) {
            throw new DefaultSysException("\u5355\u53f7\u8d85\u957f\uff01");
        }
        StringBuilder builder = new StringBuilder();
        int len = codeLen - noStr.length();
        for (int i = 0; i < len; ++i) {
            builder.append("0");
        }
        return builder.append(noStr).toString();
    }

    @Override
    public String generateExample(FlowGenerateCodeRule rule) {
        Integer codeLen = rule.getLen() == null ? 1 : rule.getLen();
        String noStr = "1";
        StringBuilder builder = new StringBuilder();
        int len = codeLen - noStr.length();
        for (int i = 0; i < len; ++i) {
            builder.append("0");
        }
        return builder.append(noStr).toString();
    }

    @Override
    public FlowGenerateCodeRule parseRule(String json) {
        FlowGenerateCodeRule rule = JsonUtil.parseObject(json, FlowGenerateCodeRule.class);
        if (StringUtil.isBlank((CharSequence)rule.getKey())) {
            rule.setKey(IdUtil.getUUID());
        }
        if (rule.getLen() == null) {
            rule.setLen(10);
        }
        if (rule.getStep() == null) {
            rule.setStep(1);
        }
        if (rule.getExpireSeconds() == null) {
            rule.setExpireSeconds(86400L);
        }
        return rule;
    }
}

