/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.locker;

import com.lframework.starter.common.locker.LockBuilder;
import com.lframework.starter.common.locker.Locker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockBuilder
implements LockBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultLockBuilder.class);
    private static final Map<String, Locker> LOCKERS = new ConcurrentHashMap<String, Locker>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locker buildLocker(String lockName, long expireTime, long waitTime) {
        Locker locker = LOCKERS.get(lockName);
        if (locker != null) {
            return locker;
        }
        Class<DefaultLockBuilder> clazz = DefaultLockBuilder.class;
        synchronized (DefaultLockBuilder.class) {
            locker = LOCKERS.get(lockName);
            if (locker != null) {
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return locker;
            }
            locker = new JavaLocker(lockName, waitTime);
            LOCKERS.put(lockName, locker);
            // ** MonitorExit[var7_5] (shouldn't be in output)
            return locker;
        }
    }

    public static class JavaLocker
    implements Locker {
        private String lockName;
        private long waitTime;
        private ReentrantLock lock;

        public JavaLocker(String lockName, long waitTime) {
            this.waitTime = waitTime;
            this.lockName = lockName;
            this.lock = new ReentrantLock();
        }

        public boolean lock() {
            try {
                return this.lock.tryLock(this.waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }

        public boolean unLock() {
            this.lock.unlock();
            LOCKERS.remove(this.lockName);
            return true;
        }

        public void close() {
            this.unLock();
        }
    }
}

