/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.redis;

import com.lframework.starter.common.utils.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisHandler {
    @Autowired
    private RedisTemplate redisTemplate;

    public boolean expire(String key, long time) {
        Assert.notNull((Object)key);
        if (time < 0L) {
            time = 1L;
        }
        return this.redisTemplate.expire((Object)key, time, TimeUnit.MILLISECONDS);
    }

    public long getExpire(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public boolean hasKey(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.hasKey((Object)key);
    }

    public void del(String ... keys) {
        Assert.notNull((Object)keys);
        this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)keys));
    }

    public Object get(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, Object value) {
        Assert.notNull((Object)key);
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long time) {
        Assert.notNull((Object)key);
        if (time < 0L) {
            this.set(key, value);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.MILLISECONDS);
        }
    }

    public long incr(String key, long delta) {
        Assert.notNull((Object)key);
        Assert.greaterThanZero((Number)delta);
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        Assert.notNull((Object)key);
        Assert.greaterThanZero((Number)delta);
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public double incr(String key, double delta) {
        Assert.notNull((Object)key);
        Assert.greaterThanZero((Number)delta);
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public double decr(String key, double delta) {
        Assert.notNull((Object)key);
        Assert.greaterThanZero((Number)delta);
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<String, Object> hgetAll(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public Map<Object, Object> hmget(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void hmset(String key, Map<String, Object> map) {
        Assert.notNull((Object)key);
        Assert.notNull(map);
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public void hset(String key, String item, Object value) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
    }

    public boolean hset(String key, String item, Object value, long time) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
        if (time < 0L) {
            time = 1L;
        }
        return this.expire(key, time);
    }

    public void hdel(String key, String ... items) {
        Assert.notNull((Object)key);
        Assert.notEmpty((Object[])items);
        this.redisTemplate.opsForHash().delete((Object)key, (Object[])items);
    }

    public boolean hHasKey(String key, String item) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)item);
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public boolean sHasKey(String key, Object value) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public long sSet(String key, Object ... values) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForSet().add((Object)key, values);
    }

    public long sSetAndExpire(String key, long time, Object ... values) {
        Assert.notNull((Object)key);
        long count = this.redisTemplate.opsForSet().add((Object)key, values);
        if (time < 0L) {
            time = 1L;
        }
        this.expire(key, time);
        return count;
    }

    public long sGetSetSize(String key) {
        Assert.notNull((Object)key);
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public long setRemove(String key, Object ... values) {
        Assert.notNull((Object)key);
        long count = this.redisTemplate.opsForSet().remove((Object)key, values);
        return count;
    }

    public List<Object> lGet(String key, long start, long end) {
        Assert.notNull((Object)key);
        Assert.greaterThanOrEqualToZero((Number)start);
        Assert.greaterThanOrEqualToZero((Number)end);
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public long lGetListSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Object lGetIndex(String key, long index) {
        Assert.notNull((Object)key);
        Assert.greaterThanOrEqualToZero((Number)index);
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    public void lSet(String key, Object value) {
        Assert.notNull((Object)key);
        this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public boolean lSet(String key, Object value, long time) {
        Assert.notNull((Object)key);
        this.redisTemplate.opsForList().rightPush((Object)key, value);
        if (time < 0L) {
            time = 1L;
        }
        return this.expire(key, time);
    }

    public void lSet(String key, List<Object> value) {
        Assert.notNull((Object)key);
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public boolean lSet(String key, List<Object> value, long time) {
        Assert.notNull((Object)key);
        this.redisTemplate.opsForList().rightPushAll((Object)key, value);
        if (time < 0L) {
            time = 1L;
        }
        return this.expire(key, time);
    }

    public void lUpdateIndex(String key, long index, Object value) {
        Assert.notNull((Object)key);
        Assert.greaterThanOrEqualToZero((Number)index);
        this.redisTemplate.opsForList().set((Object)key, index, value);
    }

    public long lRemove(String key, long count, Object value) {
        Assert.notNull((Object)key);
        Assert.greaterThanZero((Number)count);
        long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
        return remove;
    }
}

