/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.redis.locker;

import com.lframework.starter.common.locker.LockBuilder;
import com.lframework.starter.common.locker.Locker;
import com.lframework.starter.web.utils.IdUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockBuilder
implements LockBuilder {
    private static final ThreadLocal<Map<String, Locker>> LOCKERS = new ThreadLocal();
    @Resource(name="redisTemplate")
    private RedisTemplate redisTemplate;

    public Locker buildLocker(String lockName, long expireTime, long waitTime) {
        Locker locker;
        if (LOCKERS.get() == null) {
            LOCKERS.set(new HashMap());
        }
        if ((locker = LOCKERS.get().get(lockName)) != null) {
            return locker;
        }
        locker = new RedisLocker((RedisTemplate<String, Object>)this.redisTemplate, lockName, expireTime, waitTime);
        LOCKERS.get().put(lockName, locker);
        return locker;
    }

    public static class RedisLocker
    implements Locker {
        private static final Logger log = LoggerFactory.getLogger(RedisLocker.class);
        private static final String SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        private static final Long INTERVAL_TIME = 100L;
        private final RedisTemplate<String, Object> redisTemplate;
        private final byte[] key;
        private final byte[] requestId = IdUtil.getUUID().getBytes();
        private final long expireTime;
        private boolean lock;
        private long waitTime;
        private int lockCount = 0;

        public RedisLocker(RedisTemplate<String, Object> redisTemplate, String key, long expireTime, long waitTime) {
            this.redisTemplate = redisTemplate;
            this.key = key.getBytes();
            this.expireTime = expireTime;
            this.waitTime = waitTime;
        }

        public boolean lock() {
            if (this.lock) {
                this.addLockCount();
                return true;
            }
            while (!(this.lock = ((Boolean)this.redisTemplate.execute((RedisCallback)new TryLockRedisCallBack())).booleanValue()) && this.waitTime > 0L) {
                try {
                    Thread.sleep(INTERVAL_TIME);
                    this.waitTime -= INTERVAL_TIME.longValue();
                }
                catch (InterruptedException e) {
                    log.error("\u83b7\u53d6lock\u4e2d\u65ad", (Throwable)e);
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u83b7\u53d6lock\u5b8c\u6210\uff0cresult={}, key={}, requestId={}", new Object[]{this.lock, new String(this.key), this.requestId});
            }
            if (this.lock) {
                this.addLockCount();
            }
            return this.lock;
        }

        private void addLockCount() {
            ++this.lockCount;
            if (log.isDebugEnabled()) {
                log.debug("\u91cd\u5165\u6b21\u6570\uff1a{}", (Object)this.lockCount);
            }
        }

        private void reduceLockCount() {
            --this.lockCount;
            if (log.isDebugEnabled()) {
                log.debug("\u91cd\u5165\u6b21\u6570\uff1a{}", (Object)this.lockCount);
            }
        }

        public boolean unLock() {
            if (this.lock) {
                if (this.lockCount <= 1) {
                    boolean release = (Boolean)this.redisTemplate.execute((RedisCallback)new ReleaseRedisCallBack());
                    if (log.isDebugEnabled()) {
                        log.debug("\u91ca\u653elock\u5b8c\u6210\uff0cresult={}, key={}, requestId={}", new Object[]{this.lock, new String(this.key), new String(this.requestId)});
                    }
                    this.lock = !release;
                    this.reduceLockCount();
                    ((Map)LOCKERS.get()).remove(this.key);
                    return release;
                }
                this.reduceLockCount();
                return true;
            }
            return true;
        }

        public void close() {
            this.unLock();
        }

        private class ReleaseRedisCallBack
        implements RedisCallback<Boolean> {
            private ReleaseRedisCallBack() {
            }

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return (Boolean)connection.eval(RedisLocker.SCRIPT.getBytes(), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{RedisLocker.this.key, RedisLocker.this.requestId});
            }
        }

        private class TryLockRedisCallBack
        implements RedisCallback<Boolean> {
            private TryLockRedisCallBack() {
            }

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                if (log.isDebugEnabled()) {
                    log.debug("key={}, requestId={}", (Object)new String(RedisLocker.this.key), (Object)new String(RedisLocker.this.requestId));
                }
                return connection.set(RedisLocker.this.key, RedisLocker.this.requestId, Expiration.from((long)RedisLocker.this.expireTime, (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.ifAbsent());
            }
        }
    }
}

