/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.security;

import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.common.security.AbstractUserDetails;
import com.lframework.starter.web.common.security.SecurityUtil;
import com.lframework.starter.web.components.security.CheckPermissionHandler;
import com.lframework.starter.web.components.security.PermissionCalcType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPermissionHandlerImpl
implements CheckPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(CheckPermissionHandlerImpl.class);

    @Override
    public boolean valid(PermissionCalcType calcType, String ... permissions) {
        boolean valid;
        if (ArrayUtil.isEmpty((Object[])permissions)) {
            return false;
        }
        AbstractUserDetails user = SecurityUtil.getCurrentUser();
        if (user == null) {
            return false;
        }
        if (user.hasAdminPermission()) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u7528\u6237\u662f\u7ba1\u7406\u5458\uff0c\u901a\u8fc7\u6743\u9650\u6821\u9a8c");
            }
            return true;
        }
        Set permissionSet = user.getPermissions();
        boolean bl = CollectionUtil.isNotEmpty((Collection)permissionSet) && (calcType == PermissionCalcType.OR ? Arrays.stream(permissions).anyMatch(pattern -> permissionSet.stream().anyMatch(item -> StringUtil.strMatch((String)pattern, (String)item))) : Arrays.stream(permissions).allMatch(pattern -> permissionSet.stream().anyMatch(item -> StringUtil.strMatch((String)pattern, (String)item)))) ? true : (valid = false);
        if (log.isDebugEnabled()) {
            log.debug("\u5f53\u524d\u7528\u6237\u6743\u9650={}, \u9700\u8981\u6743\u9650={}, \u662f\u5426\u901a\u8fc7\u6743\u9650\u6821\u9a8c={}", new Object[]{permissionSet, permissions, valid});
        }
        return valid;
    }
}

