/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.security;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.annotation.AnnotationUtil;
import com.lframework.starter.common.exceptions.impl.AuthExpiredException;
import com.lframework.starter.web.annotations.OpenApi;
import com.lframework.starter.web.common.tenant.TenantContextHolder;
import com.lframework.starter.web.components.security.PermitAllService;
import java.lang.reflect.AnnotatedElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);
    private PermitAllService permitAllService;

    public LoginInterceptor(PermitAllService permitAllService) {
        this.permitAllService = permitAllService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.permitAllService.isMatch(request)) {
            log.debug("uri={}\uff0c\u65e0\u9700\u767b\u5f55\u9a8c\u8bc1", (Object)request.getRequestURI());
            return true;
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            OpenApi openApi = null;
            if (handlerMethod.hasMethodAnnotation(OpenApi.class)) {
                openApi = (OpenApi)handlerMethod.getMethodAnnotation(OpenApi.class);
            } else if (AnnotationUtil.hasAnnotation((AnnotatedElement)handlerMethod.getBeanType(), OpenApi.class)) {
                openApi = (OpenApi)AnnotationUtil.getAnnotation((AnnotatedElement)handlerMethod.getBeanType(), OpenApi.class);
            }
            if (openApi != null) {
                log.debug("uri={}\uff0c\u65e0\u9700\u767b\u5f55\u9a8c\u8bc1", (Object)request.getRequestURI());
                this.permitAllService.addMatch(request);
                return true;
            }
        }
        try {
            StpUtil.checkLogin();
        }
        catch (NotLoginException e) {
            throw new AuthExpiredException();
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TenantContextHolder.clearTenantId();
    }
}

