/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.security;

import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.config.properties.UploadProperties;
import com.lframework.starter.web.config.properties.WebProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class PermitAllService {
    @Autowired
    private WebProperties webProperties;
    @Autowired
    private UploadProperties uploadProperties;
    private List<Map.Entry<HttpMethod, String>> permitAllUrls;
    private Set<AntPathRequestMatcher> matchers;

    @PostConstruct
    public void init() {
        String uploadUrl;
        ArrayList<Map.Entry<HttpMethod, String>> results = new ArrayList<Map.Entry<HttpMethod, String>>();
        String filterUrl = this.webProperties.getFilterUrl();
        if (StringUtil.isNotEmpty((CharSequence)filterUrl)) {
            String[] filterUrls = filterUrl.split(",");
            for (String url : filterUrls) {
                results.add(new AbstractMap.SimpleEntry<Object, String>(null, url));
            }
        }
        results.add(new AbstractMap.SimpleEntry<HttpMethod, String>(HttpMethod.GET, (uploadUrl = this.uploadProperties.getUrl()).endsWith("/") ? uploadUrl + "**" : uploadUrl + "/**"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/doc.html"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/webjars/**"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/v2/api-docs"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/swagger-resources"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/swagger-resources/configuration/ui"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/swagger-resources/configuration/security"));
        results.add(new AbstractMap.SimpleEntry<Object, String>(null, "/v2/api-docs-ext"));
        this.permitAllUrls = results;
        this.matchers = new CopyOnWriteArraySet<AntPathRequestMatcher>();
        for (Map.Entry entry : this.permitAllUrls) {
            this.matchers.add(new AntPathRequestMatcher((String)entry.getValue(), entry.getKey() == null ? null : ((HttpMethod)entry.getKey()).toString()));
        }
    }

    public List<Map.Entry<HttpMethod, String>> getUrls() {
        return this.permitAllUrls;
    }

    public boolean isMatch(HttpServletRequest request) {
        return this.matchers.stream().anyMatch(t -> t.matches(request));
    }

    public void addMatch(HttpServletRequest request) {
        this.matchers.add(new AntPathRequestMatcher(request.getRequestURI(), request.getMethod()));
    }
}

