/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.upload.handler.impl;

import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.Assert;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.components.upload.handler.UploadHandler;
import com.lframework.starter.web.service.SysParameterService;
import com.lframework.starter.web.utils.JsonUtil;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CosUploadHandler
implements UploadHandler {
    private static final Logger log = LoggerFactory.getLogger(CosUploadHandler.class);
    @Autowired
    private SysParameterService sysParameterService;

    @Override
    public String getType() {
        return "COS";
    }

    @Override
    public String upload(InputStream is, List<String> locations, String fileName) {
        String configStr = this.sysParameterService.findRequiredByKey("upload.cos.config");
        CosConfig config = JsonUtil.parseObject(configStr, CosConfig.class);
        Assert.notBlank((CharSequence)config.getCustomUrl());
        Assert.notBlank((CharSequence)config.getRegion());
        Assert.notBlank((CharSequence)config.getBucketName());
        Assert.notBlank((CharSequence)config.getSecretId());
        Assert.notBlank((CharSequence)config.getSecretKey());
        String objectName = StringUtil.join((CharSequence)"/", locations) + fileName;
        TransferManager transferManager = null;
        try {
            transferManager = this.createTransferManager(config);
            PutObjectRequest request = new PutObjectRequest(config.getBucketName(), objectName, is, new ObjectMetadata());
            Upload upload = transferManager.upload(request);
            upload.waitForUploadResult();
            String string = config.getCustomUrl() + (config.getCustomUrl().endsWith("/") ? "" : "/") + objectName;
            return string;
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
        finally {
            if (transferManager != null) {
                transferManager.shutdownNow(true);
            }
        }
    }

    private TransferManager createTransferManager(CosConfig config) {
        COSClient cosClient = this.createCosClient(config);
        TransferManager transferManager = new TransferManager((COS)cosClient);
        return transferManager;
    }

    private COSClient createCosClient(CosConfig config) {
        String secretId = config.getSecretId();
        String secretKey = config.getSecretKey();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRegion(new Region(config.getRegion()));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        clientConfig.setSocketTimeout(30000);
        clientConfig.setConnectionTimeout(30000);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public static class CosConfig {
        private String customUrl;
        private String region;
        private String secretId;
        private String secretKey;
        private String bucketName;

        public String getCustomUrl() {
            return this.customUrl;
        }

        public String getRegion() {
            return this.region;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setCustomUrl(String customUrl) {
            this.customUrl = customUrl;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CosConfig)) {
                return false;
            }
            CosConfig other = (CosConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customUrl = this.getCustomUrl();
            String other$customUrl = other.getCustomUrl();
            if (this$customUrl == null ? other$customUrl != null : !this$customUrl.equals(other$customUrl)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$secretId = this.getSecretId();
            String other$secretId = other.getSecretId();
            if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
                return false;
            }
            String this$secretKey = this.getSecretKey();
            String other$secretKey = other.getSecretKey();
            if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CosConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customUrl = this.getCustomUrl();
            result = result * 59 + ($customUrl == null ? 43 : $customUrl.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $secretId = this.getSecretId();
            result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
            String $secretKey = this.getSecretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            return result;
        }

        public String toString() {
            return "CosUploadHandler.CosConfig(customUrl=" + this.getCustomUrl() + ", region=" + this.getRegion() + ", secretId=" + this.getSecretId() + ", secretKey=" + this.getSecretKey() + ", bucketName=" + this.getBucketName() + ")";
        }
    }
}

