/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.upload.handler.impl;

import com.lframework.starter.common.utils.Assert;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.FileUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.components.upload.handler.UploadHandler;
import com.lframework.starter.web.config.properties.UploadProperties;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalUploadHandler
implements UploadHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalUploadHandler.class);
    @Autowired
    private UploadProperties uploadProperties;

    @Override
    public String getType() {
        return "LOCAL";
    }

    @Override
    public String upload(InputStream is, List<String> locations, String fileName) {
        String baseUrl;
        String domain = this.uploadProperties.getDomain();
        if (domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        if (!(baseUrl = this.uploadProperties.getUrl()).startsWith("/")) {
            baseUrl = "/" + baseUrl;
        }
        String baseLocation = this.uploadProperties.getLocation();
        return this.upload(is, baseLocation, locations, fileName, domain + baseUrl);
    }

    private String upload(InputStream is, String baseLocation, List<String> locations, String fileName, String baseUrl) {
        Assert.notNull((Object)is);
        Assert.notBlank((CharSequence)baseLocation);
        Assert.notBlank((CharSequence)fileName);
        if (!baseLocation.endsWith(File.separator)) {
            baseLocation = baseLocation + File.separator;
        }
        if (StringUtil.isEmpty((CharSequence)baseUrl)) {
            baseUrl = "";
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        String fullPath = baseLocation + (CollectionUtil.isEmpty(locations) ? "" : CollectionUtil.join(locations, (CharSequence)File.separator)) + File.separator;
        File dest = FileUtil.touch((String)fullPath, (String)fileName);
        FileUtil.writeFromStream((InputStream)is, (File)dest);
        return baseUrl + (CollectionUtil.isEmpty(locations) ? "" : CollectionUtil.join(locations, (CharSequence)"/") + "/") + fileName;
    }
}

