/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.upload.handler.impl;

import cn.hutool.core.util.URLUtil;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.Assert;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.components.upload.handler.UploadHandler;
import com.lframework.starter.web.service.SysParameterService;
import com.lframework.starter.web.utils.JsonUtil;
import com.obs.services.ObsClient;
import com.obs.services.model.PutObjectResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ObsUploadHandler
implements UploadHandler {
    private static final Logger log = LoggerFactory.getLogger(ObsUploadHandler.class);
    @Autowired
    private SysParameterService sysParameterService;

    @Override
    public String getType() {
        return "OBS";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String upload(InputStream is, List<String> locations, String fileName) {
        String configStr = this.sysParameterService.findRequiredByKey("upload.obs.config");
        ObsConfig config = JsonUtil.parseObject(configStr, ObsConfig.class);
        Assert.notBlank((CharSequence)config.getEndpoint());
        Assert.notBlank((CharSequence)config.getBucketName());
        Assert.notBlank((CharSequence)config.getAk());
        Assert.notBlank((CharSequence)config.getSk());
        String objectName = StringUtil.join((CharSequence)"/", locations) + fileName;
        try (ObsClient obsClient = new ObsClient(config.getAk(), config.getSk(), config.getEndpoint());){
            PutObjectResult result = obsClient.putObject(config.getBucketName(), objectName, is);
            if (StringUtil.isNotBlank((CharSequence)config.getCustomUrl())) {
                String string = config.getCustomUrl() + (config.getCustomUrl().endsWith("/") ? "" : "/") + objectName;
                return string;
            }
            String string = URLUtil.decode((String)result.getObjectUrl());
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
    }

    public static class ObsConfig {
        private String customUrl;
        private String endpoint;
        private String ak;
        private String sk;
        private String bucketName;

        public String getCustomUrl() {
            return this.customUrl;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAk() {
            return this.ak;
        }

        public String getSk() {
            return this.sk;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setCustomUrl(String customUrl) {
            this.customUrl = customUrl;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAk(String ak) {
            this.ak = ak;
        }

        public void setSk(String sk) {
            this.sk = sk;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObsConfig)) {
                return false;
            }
            ObsConfig other = (ObsConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customUrl = this.getCustomUrl();
            String other$customUrl = other.getCustomUrl();
            if (this$customUrl == null ? other$customUrl != null : !this$customUrl.equals(other$customUrl)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$ak = this.getAk();
            String other$ak = other.getAk();
            if (this$ak == null ? other$ak != null : !this$ak.equals(other$ak)) {
                return false;
            }
            String this$sk = this.getSk();
            String other$sk = other.getSk();
            if (this$sk == null ? other$sk != null : !this$sk.equals(other$sk)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObsConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customUrl = this.getCustomUrl();
            result = result * 59 + ($customUrl == null ? 43 : $customUrl.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $ak = this.getAk();
            result = result * 59 + ($ak == null ? 43 : $ak.hashCode());
            String $sk = this.getSk();
            result = result * 59 + ($sk == null ? 43 : $sk.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            return result;
        }

        public String toString() {
            return "ObsUploadHandler.ObsConfig(customUrl=" + this.getCustomUrl() + ", endpoint=" + this.getEndpoint() + ", ak=" + this.getAk() + ", sk=" + this.getSk() + ", bucketName=" + this.getBucketName() + ")";
        }
    }
}

