/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.components.upload.handler.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.lframework.starter.common.utils.Assert;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.components.upload.handler.UploadHandler;
import com.lframework.starter.web.service.SysParameterService;
import com.lframework.starter.web.utils.JsonUtil;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class OssUploadHandler
implements UploadHandler {
    @Autowired
    private SysParameterService sysParameterService;

    @Override
    public String getType() {
        return "OSS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(InputStream is, List<String> locations, String fileName) {
        String configStr = this.sysParameterService.findRequiredByKey("upload.oss.config");
        OssConfig config = JsonUtil.parseObject(configStr, OssConfig.class);
        Assert.notBlank((CharSequence)config.getEndpoint());
        Assert.notBlank((CharSequence)config.getBucketName());
        Assert.notBlank((CharSequence)config.getAccessKeyId());
        Assert.notBlank((CharSequence)config.getAccessKeySecret());
        OSS ossClient = new OSSClientBuilder().build(StringUtil.isBlank((CharSequence)config.getInternalEndPoint()) ? config.getEndpoint() : config.getInternalEndPoint(), config.getAccessKeyId(), config.getAccessKeySecret());
        String objectName = StringUtil.join((CharSequence)"/", locations) + fileName;
        try {
            ossClient.putObject(config.getBucketName(), objectName, is);
            if (StringUtil.isNotBlank((CharSequence)config.getCustomUrl())) {
                String string = config.getCustomUrl() + (config.getCustomUrl().endsWith("/") ? "" : "/") + objectName;
                return string;
            }
            String string = "https://" + config.getBucketName() + "." + config.getEndpoint() + "/" + objectName;
            return string;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public static class OssConfig {
        private String customUrl;
        private String endpoint;
        private String internalEndPoint;
        private String accessKeyId;
        private String accessKeySecret;
        private String bucketName;

        public String getCustomUrl() {
            return this.customUrl;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getInternalEndPoint() {
            return this.internalEndPoint;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public void setCustomUrl(String customUrl) {
            this.customUrl = customUrl;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setInternalEndPoint(String internalEndPoint) {
            this.internalEndPoint = internalEndPoint;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public void setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OssConfig)) {
                return false;
            }
            OssConfig other = (OssConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customUrl = this.getCustomUrl();
            String other$customUrl = other.getCustomUrl();
            if (this$customUrl == null ? other$customUrl != null : !this$customUrl.equals(other$customUrl)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$internalEndPoint = this.getInternalEndPoint();
            String other$internalEndPoint = other.getInternalEndPoint();
            if (this$internalEndPoint == null ? other$internalEndPoint != null : !this$internalEndPoint.equals(other$internalEndPoint)) {
                return false;
            }
            String this$accessKeyId = this.getAccessKeyId();
            String other$accessKeyId = other.getAccessKeyId();
            if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
                return false;
            }
            String this$accessKeySecret = this.getAccessKeySecret();
            String other$accessKeySecret = other.getAccessKeySecret();
            if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
                return false;
            }
            String this$bucketName = this.getBucketName();
            String other$bucketName = other.getBucketName();
            return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OssConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customUrl = this.getCustomUrl();
            result = result * 59 + ($customUrl == null ? 43 : $customUrl.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $internalEndPoint = this.getInternalEndPoint();
            result = result * 59 + ($internalEndPoint == null ? 43 : $internalEndPoint.hashCode());
            String $accessKeyId = this.getAccessKeyId();
            result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
            String $accessKeySecret = this.getAccessKeySecret();
            result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
            String $bucketName = this.getBucketName();
            result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
            return result;
        }

        public String toString() {
            return "OssUploadHandler.OssConfig(customUrl=" + this.getCustomUrl() + ", endpoint=" + this.getEndpoint() + ", internalEndPoint=" + this.getInternalEndPoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ")";
        }
    }
}

