/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.config;

import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.web.config.properties.CacheProperties;
import java.time.Duration;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableCaching
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfiguration
extends CachingConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(CacheAutoConfiguration.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Bean
    public RedisCacheWriter writer() {
        return RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
    }

    @Bean
    public CacheManager cacheManager(CacheProperties properties) {
        HashMap configurationMap = new HashMap();
        if (!CollectionUtil.isEmpty(properties.getRegions())) {
            properties.getRegions().forEach((k, v) -> configurationMap.put(k, RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(v))));
        }
        return RedisCacheManager.builder((RedisCacheWriter)this.writer()).initialCacheNames(configurationMap.keySet()).cacheDefaults(RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(properties.getTtl()))).withInitialCacheConfigurations(configurationMap).build();
    }
}

