/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.config;

import com.lframework.starter.web.common.utils.ApplicationUtil;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
public class SwaggerAutoConfiguration
implements WebMvcConfigurer {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    @ConditionalOnProperty(value={"knife4j.enable"}, matchIfMissing=true)
    public SwaggerReadyListener swaggerReadyListener() {
        return new SwaggerReadyListener();
    }

    public static class SwaggerReadyListener
    implements ApplicationListener<ApplicationReadyEvent> {
        private static final Logger log = LoggerFactory.getLogger(SwaggerReadyListener.class);

        public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
            log.info("\n----------------------------------------------------------\n\tApplication '{}' \u5df2\u542f\u52a8\uff01 \u8bbf\u95ee\u5730\u5740\uff1a\n\tLocal\uff1a \thttp://localhost:{}\n\tExternal\uff1a \thttp://{}:{}\n\tDoc: \thttp://{}:{}/doc.html\n----------------------------------------------------------", new Object[]{ApplicationUtil.getProperty((String)"spring.application.name"), ApplicationUtil.getProperty((String)"server.port"), InetAddress.getLocalHost().getHostAddress(), ApplicationUtil.getProperty((String)"server.port"), InetAddress.getLocalHost().getHostAddress(), ApplicationUtil.getProperty((String)"server.port")});
        }
    }
}

