/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.config;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.lframework.starter.web.components.tenant.TenantInterceptor;
import com.lframework.starter.web.config.properties.SecretProperties;
import com.lframework.starter.web.interceptors.TenantInterceptorImpl;
import com.lframework.starter.web.listeners.TenantListener;
import com.lframework.starter.web.utils.DataSourceUtil;
import com.lframework.starter.web.utils.EncryptUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="jugg.tenant", value={"enabled"}, matchIfMissing=false, havingValue="true")
public class TenantConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantConfiguration.class);
    @Autowired
    private DynamicDataSourceProperties dynamicDataSourceProperties;

    @Bean
    public TenantInterceptor tenantInterceptor() {
        return new TenantInterceptorImpl();
    }

    @Bean
    public TenantListener.ReloadTenantListener reloadTenantListener() {
        return new TenantListener.ReloadTenantListener();
    }

    @Bean
    public TenantListener.SetTenantListener setTenantListener() {
        return new TenantListener.SetTenantListener();
    }

    @Bean
    public TenantListener.ClearTenantListener clearTenantListener() {
        return new TenantListener.ClearTenantListener();
    }

    @Bean
    public AbstractJdbcDataSourceProvider tenantDataSourceProvider(final SecretProperties secretProperties) {
        final DataSourceProperty dataSourceProperty = (DataSourceProperty)this.dynamicDataSourceProperties.getDatasource().get("master");
        return new AbstractJdbcDataSourceProvider(dataSourceProperty.getDriverClassName(), dataSourceProperty.getUrl(), dataSourceProperty.getUsername(), dataSourceProperty.getPassword()){

            protected Map<String, DataSourceProperty> executeStmt(Statement statement) throws SQLException {
                HashMap<String, DataSourceProperty> dataSourcePropertyMap = new HashMap<String, DataSourceProperty>();
                ResultSet rs = statement.executeQuery("select * from tenant where available = true");
                while (rs.next()) {
                    String name = rs.getString("id");
                    String username = rs.getString("jdbc_username");
                    String password = rs.getString("jdbc_password");
                    String url = rs.getString("jdbc_url");
                    DataSourceProperty property = DataSourceUtil.createDataSourceProperty(dataSourceProperty, url, username, EncryptUtil.decrypt(password, secretProperties));
                    log.info("\u52a0\u8f7d\u79df\u6237 {} \u6570\u636e\u6e90 url {}", (Object)name, (Object)property.getUrl());
                    dataSourcePropertyMap.put(name, property);
                }
                return dataSourcePropertyMap;
            }
        };
    }
}

