/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jdk8.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.lframework.starter.common.utils.IdWorker;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.components.security.CheckPermissionHandler;
import com.lframework.starter.web.components.security.CheckPermissionHandlerImpl;
import com.lframework.starter.web.components.security.PermitAllService;
import com.lframework.starter.web.components.trace.DefaultTraceBuilder;
import com.lframework.starter.web.components.trace.TraceBuilder;
import com.lframework.starter.web.config.properties.DefaultSettingProperties;
import com.lframework.starter.web.config.properties.SecretProperties;
import com.lframework.starter.web.config.properties.WebProperties;
import com.lframework.starter.web.sign.CheckSignHandler;
import com.lframework.starter.web.sign.DefaultCheckSignHandler;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class, DefaultSettingProperties.class, SecretProperties.class})
public class WebAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public CorsFilter getCorsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public Converter<String, LocalDateTime> localDateTimeConvert() {
        return new Converter<String, LocalDateTime>(){

            public LocalDateTime convert(String source) {
                if (StringUtil.isBlank((CharSequence)source)) {
                    return null;
                }
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime dateTime = LocalDateTime.parse(source, df);
                return dateTime;
            }
        };
    }

    @Bean
    public Converter<String, LocalDate> localDateConvert() {
        return new Converter<String, LocalDate>(){

            public LocalDate convert(String source) {
                if (StringUtil.isBlank((CharSequence)source)) {
                    return null;
                }
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate date = LocalDate.parse(source, df);
                return date;
            }
        };
    }

    @Bean
    public Converter<String, LocalTime> localTimeConvert() {
        return new Converter<String, LocalTime>(){

            public LocalTime convert(String source) {
                if (StringUtil.isBlank((CharSequence)source)) {
                    return null;
                }
                DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
                LocalTime time = LocalTime.parse(source, df);
                return time;
            }
        };
    }

    @Bean
    public ObjectMapper getObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper om = builder.build().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new JavaLocalDateTimeModule());
        return om;
    }

    @Bean
    public IdWorker getIdWorker(WebProperties webProperties) {
        Long workerId = webProperties.getWorkerId();
        Long centerId = webProperties.getCenterId();
        if (workerId <= 0L || centerId <= 0L) {
            return new IdWorker();
        }
        return new IdWorker(workerId.longValue(), centerId.longValue());
    }

    @Bean
    @ConditionalOnMissingBean(value={PermitAllService.class})
    public PermitAllService permitAllService() {
        return new PermitAllService();
    }

    @Bean(value={"permission"})
    @ConditionalOnMissingBean(value={CheckPermissionHandler.class})
    public CheckPermissionHandler checkPermissionHandler() {
        return new CheckPermissionHandlerImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={TraceBuilder.class})
    public TraceBuilder getTraceBuilder() {
        return new DefaultTraceBuilder();
    }

    @Bean
    @ConditionalOnMissingBean(value={CheckSignHandler.class})
    public CheckSignHandler getCheckSignHandler() {
        return new DefaultCheckSignHandler();
    }

    class JavaLocalDateTimeModule
    extends SimpleModule {
        public JavaLocalDateTimeModule() {
            super(PackageVersion.VERSION);
            this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
            this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        }
    }
}

