/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.handlers;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.lframework.starter.common.utils.ObjectUtil;
import com.lframework.starter.web.common.security.AbstractUserDetails;
import com.lframework.starter.web.common.security.SecurityUtil;
import com.lframework.starter.web.config.properties.DefaultSettingProperties;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultBaseEntityFillHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultBaseEntityFillHandler.class);
    @Autowired
    private DefaultSettingProperties defaultSettingProperties;

    public void insertFill(MetaObject metaObject) {
        AbstractUserDetails user = SecurityUtil.getCurrentUser();
        if (ObjectUtil.isNotNull((Object)user)) {
            this.strictInsertFill(metaObject, "createBy", String.class, user.getName());
            this.strictInsertFill(metaObject, "updateBy", String.class, user.getName());
            this.strictInsertFill(metaObject, "createById", String.class, user.getId());
            this.strictInsertFill(metaObject, "updateById", String.class, user.getId());
        } else {
            this.strictInsertFill(metaObject, "createBy", String.class, this.defaultSettingProperties.getDefaultUserName());
            this.strictInsertFill(metaObject, "updateBy", String.class, this.defaultSettingProperties.getDefaultUserName());
            this.strictInsertFill(metaObject, "createById", String.class, this.defaultSettingProperties.getDefaultUserId());
            this.strictInsertFill(metaObject, "updateById", String.class, this.defaultSettingProperties.getDefaultUserId());
        }
        this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, LocalDateTime.now());
        this.strictInsertFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
    }

    public void updateFill(MetaObject metaObject) {
        AbstractUserDetails user = SecurityUtil.getCurrentUser();
        if (ObjectUtil.isNotNull((Object)user)) {
            this.strictUpdateFill(metaObject, "updateBy", String.class, user.getName());
            this.strictUpdateFill(metaObject, "updateById", String.class, user.getId());
        } else {
            this.strictUpdateFill(metaObject, "updateBy", String.class, this.defaultSettingProperties.getDefaultUserName());
            this.strictUpdateFill(metaObject, "updateById", String.class, this.defaultSettingProperties.getDefaultUserName());
        }
        this.strictUpdateFill(metaObject, "updateTime", LocalDateTime.class, LocalDateTime.now());
    }

    public MetaObjectHandler strictFillStrategy(MetaObject metaObject, String fieldName, Supplier<?> fieldVal) {
        if ("updateBy".equals(fieldName) || "updateById".equals(fieldName) || "updateTime".equals(fieldName)) {
            Object obj = fieldVal.get();
            if (Objects.nonNull(obj)) {
                metaObject.setValue(fieldName, obj);
            }
        } else {
            return super.strictFillStrategy(metaObject, fieldName, fieldVal);
        }
        return this;
    }
}

