/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.listeners;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.lframework.starter.web.common.event.ClearTenantEvent;
import com.lframework.starter.web.common.event.ReloadTenantEvent;
import com.lframework.starter.web.common.event.SetTenantEvent;
import com.lframework.starter.web.utils.DataSourceUtil;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class TenantListener {

    public static class ClearTenantListener
    implements ApplicationListener<ClearTenantEvent> {
        public void onApplicationEvent(ClearTenantEvent event) {
            DynamicDataSourceContextHolder.clear();
        }
    }

    public static class SetTenantListener
    implements ApplicationListener<SetTenantEvent> {
        public void onApplicationEvent(SetTenantEvent event) {
            DynamicDataSourceContextHolder.push((String)String.valueOf(event.getTenantId()));
        }
    }

    public static class ReloadTenantListener
    implements ApplicationListener<ReloadTenantEvent>,
    Ordered {
        @Autowired
        private DynamicDataSourceProperties dynamicDataSourceProperties;
        @Autowired
        private DataSource dataSource;

        public void onApplicationEvent(ReloadTenantEvent event) {
            DataSourceProperty dataSourceProperty = (DataSourceProperty)this.dynamicDataSourceProperties.getDatasource().get("master");
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
            ds.addDataSource(String.valueOf(event.getTenantId()), DataSourceUtil.createDataSource(dataSourceProperty, event.getJdbcUrl(), event.getJdbcUsername(), event.getJdbcPassword(), event.getDriver()));
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

