/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.resp;

import com.lframework.starter.common.constants.ResponseConstants;
import com.lframework.starter.common.exceptions.BaseException;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.components.trace.TraceBuilder;
import com.lframework.starter.web.resp.InvokeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(InvokeResultBuilder.class);

    public static InvokeResult<Void> success() {
        InvokeResult<Void> invokeResult = new InvokeResult<Void>();
        invokeResult.setCode(ResponseConstants.INVOKE_RESULT_SUCCESS_CODE);
        invokeResult.setMsg("success");
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }

    public static <T> InvokeResult<T> success(T data) {
        InvokeResult<T> invokeResult = new InvokeResult<T>();
        invokeResult.setCode(ResponseConstants.INVOKE_RESULT_SUCCESS_CODE);
        invokeResult.setMsg("success");
        invokeResult.setData(data);
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }

    public static InvokeResult<Void> fail() {
        InvokeResult<Void> invokeResult = new InvokeResult<Void>();
        invokeResult.setCode(ResponseConstants.INVOKE_RESULT_FAIL_CODE);
        invokeResult.setMsg("fail");
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }

    public static InvokeResult<Void> fail(String msg) {
        InvokeResult<Void> invokeResult = new InvokeResult<Void>();
        invokeResult.setCode(ResponseConstants.INVOKE_RESULT_FAIL_CODE);
        invokeResult.setMsg(msg);
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }

    public static <T> InvokeResult<T> fail(String msg, T data) {
        InvokeResult<T> invokeResult = new InvokeResult<T>();
        invokeResult.setCode(ResponseConstants.INVOKE_RESULT_FAIL_CODE);
        invokeResult.setMsg(msg);
        invokeResult.setData(data);
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }

    public static InvokeResult<Void> fail(BaseException e) {
        InvokeResult<Void> invokeResult = new InvokeResult<Void>();
        invokeResult.setCode(e.getCode());
        invokeResult.setMsg(e.getMsg());
        invokeResult.setTraceId(((TraceBuilder)ApplicationUtil.getBean(TraceBuilder.class)).getTraceId(false));
        return invokeResult;
    }
}

