/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.utils.DateUtil;
import com.lframework.starter.common.utils.StringUtil;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronUtil {
    private static final Logger log = LoggerFactory.getLogger(CronUtil.class);

    public static String getDateTimeCron(LocalDateTime dateTime) {
        return dateTime.getSecond() + " " + dateTime.getMinute() + " " + dateTime.getHour() + " " + dateTime.getDayOfMonth() + " " + dateTime.getMonthValue() + " ? " + dateTime.getYear();
    }

    public static String getDateCron(LocalDate date) {
        return "0 0 0 " + date.getDayOfMonth() + " " + date.getMonthValue() + " ? " + date.getYear();
    }

    public static String getDateMaxCron(LocalDate date) {
        return "59 59 23 " + date.getDayOfMonth() + " " + date.getMonthValue() + " ? " + date.getYear();
    }

    public static Boolean match(String cron, LocalDateTime dateTime) {
        if (StringUtil.isBlank((CharSequence)cron) || dateTime == null) {
            return false;
        }
        CronExpression exp = null;
        try {
            exp = new CronExpression(cron);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return exp.isSatisfiedBy(DateUtil.toDate((LocalDateTime)dateTime));
    }
}

