/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.ObjectUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.enums.BaseEnum;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumUtil {
    private static final Logger log = LoggerFactory.getLogger(EnumUtil.class);
    private static final Map<Class<? extends BaseEnum<? extends Serializable>>, List<? extends BaseEnum<? extends Serializable>>> ENUM_POOL = new ConcurrentHashMap<Class<? extends BaseEnum<? extends Serializable>>, List<? extends BaseEnum<? extends Serializable>>>();

    public static <C extends BaseEnum<? extends Serializable>> String getDesc(Class<C> clazz, Serializable code) {
        List<BaseEnum> enumList = EnumUtil.getEnumList(clazz);
        for (BaseEnum c : enumList) {
            if (!c.getCode().equals(code)) continue;
            return c.getDesc();
        }
        return null;
    }

    public static <C extends BaseEnum<? extends Serializable>> C getByCode(Class<C> clazz, Serializable code) {
        if (ObjectUtil.isNull((Object)code)) {
            return null;
        }
        List<BaseEnum> enumList = EnumUtil.getEnumList(clazz);
        for (BaseEnum c : enumList) {
            if (c.getCode() == null || !String.valueOf(c.getCode()).equals(String.valueOf(code))) continue;
            return (C)c;
        }
        return null;
    }

    public static <C extends BaseEnum<? extends Serializable>> C getByDesc(Class<C> clazz, String desc) {
        if (StringUtil.isNullOrUndefined((CharSequence)desc)) {
            return null;
        }
        List<BaseEnum> enumList = EnumUtil.getEnumList(clazz);
        for (BaseEnum c : enumList) {
            if (!c.getDesc().equals(desc)) continue;
            return (C)c;
        }
        return null;
    }

    public static <C extends BaseEnum<? extends Serializable>> List<String> getDescs(Class<C> clazz) {
        List<C> enumList = EnumUtil.getEnumList(clazz);
        return enumList.stream().map(t -> t.getDesc()).collect(Collectors.toList());
    }

    private static <C extends BaseEnum<? extends Serializable>> List<C> getEnumList(Class<C> clazz) {
        List<Object> enumList;
        if (!ENUM_POOL.containsKey(clazz)) {
            try {
                enumList = new ArrayList();
                if (Enum.class.isAssignableFrom(clazz)) {
                    Method method = clazz.getMethod("values", new Class[0]);
                    Object[] enums = (BaseEnum[])method.invoke(clazz, new Object[0]);
                    if (ArrayUtil.isNotEmpty((Object[])enums)) {
                        enumList.addAll(Arrays.asList(enums));
                    }
                } else {
                    Map enums = ApplicationUtil.getBeansOfType(clazz);
                    if (!CollectionUtil.isEmpty((Map)enums)) {
                        enumList.addAll(enums.values());
                    }
                }
                ENUM_POOL.put(clazz, enumList);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new DefaultSysException(e.getMessage());
            }
        }
        enumList = ENUM_POOL.get(clazz);
        return enumList;
    }
}

