/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.FileUtil;
import com.lframework.starter.common.utils.ReflectUtil;
import com.lframework.starter.web.annotations.excel.ExcelRequired;
import com.lframework.starter.web.components.excel.ExcelHorizontalCellStyleStrategy;
import com.lframework.starter.web.components.excel.ExcelModel;
import com.lframework.starter.web.components.excel.ExcelMultipartWriterBuilder;
import com.lframework.starter.web.components.excel.ExcelMultipartWriterSheetBuilder;
import com.lframework.starter.web.utils.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final WriteHandler DEFAULT_COLUMN_WIDTH_STYLE_STRATEGY = new LongestMatchColumnWidthStyleStrategy();

    public static <T> ExcelReaderBuilder read(MultipartFile file, Class<T> clazz, ReadListener<T> listener) {
        try {
            return EasyExcel.read((InputStream)file.getInputStream(), clazz, listener);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
    }

    public static <T extends ExcelModel> void exportXls(String sheetName, Class<T> clazz) {
        ExcelUtil.exportXls(sheetName, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXls(String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXls(sheetName, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXls(String fileName, String sheetName, Class<T> clazz) {
        ExcelUtil.exportXls(fileName, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXls(String fileName, String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXls(fileName, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXls(String fileName, String sheetName, Class<T> clazz, List<T> datas, List<WriteHandler> writeHandlers) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try (ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(fileName + ExcelTypeEnum.XLS.getValue(), StandardCharsets.UTF_8.name());
            response.setContentType("application/msexcel");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("FileName", fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelUtil.exportExcel((OutputStream)os, sheetName, ExcelTypeEnum.XLS, clazz, datas, writeHandlers);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException("Xls\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    public static <T extends ExcelModel> void exportXlsx(String sheetName, Class<T> clazz) {
        ExcelUtil.exportXlsx(sheetName, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXlsx(String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXlsx(sheetName, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXlsx(String fileName, String sheetName, Class<T> clazz) {
        ExcelUtil.exportXlsx(fileName, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXlsx(String fileName, String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXlsx(fileName, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXlsx(String fileName, String sheetName, Class<T> clazz, List<T> datas, List<WriteHandler> writeHandlers) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try (ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(fileName + ExcelTypeEnum.XLSX.getValue(), StandardCharsets.UTF_8.name());
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("FileName", fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelUtil.exportExcel((OutputStream)os, sheetName, ExcelTypeEnum.XLSX, clazz, datas, writeHandlers);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException("Xls\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    public static <T extends ExcelModel> void exportXls(File file, String sheetName, Class<T> clazz) {
        ExcelUtil.exportXls(file, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXls(File file, String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXls(file, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXls(File file, String sheetName, Class<T> clazz, List<T> datas, List<WriteHandler> writeHandlers) {
        ExcelUtil.exportExcel(FileUtil.getOutputStream((File)file), sheetName, ExcelTypeEnum.XLS, clazz, datas, writeHandlers);
    }

    public static <T extends ExcelModel> void exportXlsx(File file, String sheetName, Class<T> clazz) {
        ExcelUtil.exportXlsx(file, sheetName, clazz, CollectionUtil.emptyList(), null);
    }

    public static <T extends ExcelModel> void exportXlsx(File file, String sheetName, Class<T> clazz, List<T> datas) {
        ExcelUtil.exportXlsx(file, sheetName, clazz, datas, null);
    }

    public static <T extends ExcelModel> void exportXlsx(File file, String sheetName, Class<T> clazz, List<T> datas, List<WriteHandler> writeHandlers) {
        ExcelUtil.exportExcel(FileUtil.getOutputStream((File)file), sheetName, ExcelTypeEnum.XLSX, clazz, datas, writeHandlers);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(String sheetName, List<String> head) {
        return ExcelUtil.multipartExportXls(sheetName, sheetName, head);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(String fileName, String sheetName, List<String> head) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try {
            ServletOutputStream os = response.getOutputStream();
            fileName = URLEncoder.encode(fileName + ExcelTypeEnum.XLS.getValue(), StandardCharsets.UTF_8.name());
            response.setContentType("application/msexcel");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("FileName", fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            return ExcelUtil.multipartExportExcel((OutputStream)os, sheetName, ExcelTypeEnum.XLS, head);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException("Xls\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    private static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportExcel(OutputStream os, String sheetName, ExcelTypeEnum excelType, List<String> head) {
        ArrayList<List<String>> headWrapper = new ArrayList<List<String>>();
        if (!CollectionUtil.isEmpty(head)) {
            for (String s : head) {
                headWrapper.add(Collections.singletonList(s));
            }
        }
        ExcelMultipartWriterSheetBuilder builder = ((ExcelMultipartWriterBuilder)((ExcelMultipartWriterBuilder)new ExcelMultipartWriterBuilder().file(os).excelType(excelType).useDefaultStyle(false)).head(headWrapper)).sheet(sheetName);
        List<WriteHandler> writeHandlers = ExcelUtil.getWriteHandlers();
        writeHandlers.forEach(arg_0 -> ((ExcelMultipartWriterSheetBuilder)builder).registerWriteHandler(arg_0));
        return builder;
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportXls(sheetName, sheetName, clazz);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(String fileName, String sheetName, Class<T> clazz) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try {
            ServletOutputStream os = response.getOutputStream();
            fileName = URLEncoder.encode(fileName + ExcelTypeEnum.XLS.getValue(), StandardCharsets.UTF_8.name());
            response.setContentType("application/msexcel");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("FileName", fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            return ExcelUtil.multipartExportExcel((OutputStream)os, sheetName, ExcelTypeEnum.XLS, clazz);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException("Xls\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXlsx(String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportXlsx(sheetName, sheetName, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXlsx(String fileName, String sheetName, Class<T> clazz) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try (ServletOutputStream os = response.getOutputStream();){
            fileName = URLEncoder.encode(fileName + ExcelTypeEnum.XLSX.getValue(), StandardCharsets.UTF_8.name());
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("FileName", fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            ExcelMultipartWriterSheetBuilder excelMultipartWriterSheetBuilder = ExcelUtil.multipartExportExcel((OutputStream)os, sheetName, ExcelTypeEnum.XLSX, clazz);
            return excelMultipartWriterSheetBuilder;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException("Xls\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(File file, String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportXls(file, sheetName, sheetName, clazz);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXls(File file, String fileName, String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportExcel((OutputStream)FileUtil.getOutputStream((File)file), sheetName, ExcelTypeEnum.XLS, clazz);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXlsx(File file, String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportXlsx(file, sheetName, sheetName, clazz);
    }

    public static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportXlsx(File file, String fileName, String sheetName, Class<T> clazz) {
        return ExcelUtil.multipartExportExcel((OutputStream)FileUtil.getOutputStream((File)file), sheetName, ExcelTypeEnum.XLSX, clazz);
    }

    private static <T extends ExcelModel> void exportExcel(OutputStream os, String sheetName, ExcelTypeEnum excelType, Class<T> clazz, List<T> datas, List<WriteHandler> writeHandlers) {
        ExcelMultipartWriterSheetBuilder builder = ((ExcelMultipartWriterBuilder)((ExcelMultipartWriterBuilder)new ExcelMultipartWriterBuilder().file(os).excelType(excelType).useDefaultStyle(false)).head(clazz)).sheet(sheetName);
        writeHandlers = ExcelUtil.getWriteHandlers(writeHandlers, clazz);
        writeHandlers.forEach(arg_0 -> ((ExcelMultipartWriterSheetBuilder)builder).registerWriteHandler(arg_0));
        builder.doWrite(datas);
        builder.finish();
    }

    private static <T extends ExcelModel> ExcelMultipartWriterSheetBuilder multipartExportExcel(OutputStream os, String sheetName, ExcelTypeEnum excelType, Class<T> clazz) {
        ExcelMultipartWriterSheetBuilder builder = ((ExcelMultipartWriterBuilder)((ExcelMultipartWriterBuilder)new ExcelMultipartWriterBuilder().file(os).excelType(excelType).useDefaultStyle(false)).head(clazz)).sheet(sheetName);
        List<WriteHandler> writeHandlers = ExcelUtil.getWriteHandlers(null, clazz);
        writeHandlers.forEach(arg_0 -> ((ExcelMultipartWriterSheetBuilder)builder).registerWriteHandler(arg_0));
        return builder;
    }

    public static List<WriteHandler> getWriteHandlers() {
        return ExcelUtil.getWriteHandlers(null, null);
    }

    public static List<WriteHandler> getWriteHandlers(List<WriteHandler> writeHandlers, Class headClass) {
        ArrayList<WriteHandler> retList = new ArrayList<WriteHandler>();
        retList.addAll(ExcelUtil.getDefaultStyle(ExcelUtil.getRequiredFieldNames(headClass)));
        if (CollectionUtil.isEmpty(writeHandlers)) {
            retList.add(DEFAULT_COLUMN_WIDTH_STYLE_STRATEGY);
            return retList;
        }
        retList.addAll(writeHandlers);
        if (writeHandlers.stream().anyMatch(t -> t instanceof AbstractColumnWidthStyleStrategy)) {
            return retList;
        }
        retList.add(DEFAULT_COLUMN_WIDTH_STYLE_STRATEGY);
        return retList;
    }

    private static List<WriteHandler> getDefaultStyle(Set<String> requiredFiledNames) {
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setFillPatternType(FillPatternType.NO_FILL);
        contentWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        contentWriteCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        contentWriteCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        contentWriteCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontName("\u5b8b\u4f53");
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        handlerList.add((WriteHandler)new ExcelHorizontalCellStyleStrategy(ExcelUtil.getHeadStyle(false), ExcelUtil.getHeadStyle(true), contentWriteCellStyle, requiredFiledNames));
        return handlerList;
    }

    private static WriteCellStyle getHeadStyle(boolean isRequiredField) {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        headWriteCellStyle.setBorderTop(BorderStyle.THIN);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        headWriteCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        headWriteCellStyle.setLeftBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        headWriteCellStyle.setRightBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontName("\u5b8b\u4f53");
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        headWriteFont.setBold(Boolean.valueOf(true));
        if (isRequiredField) {
            headWriteFont.setColor(Short.valueOf((short)10));
        }
        headWriteCellStyle.setWriteFont(headWriteFont);
        return headWriteCellStyle;
    }

    private static Set<String> getRequiredFieldNames(Class headClass) {
        if (headClass == null) {
            return null;
        }
        Object[] fields = ReflectUtil.getFields((Class)headClass, t -> t.getAnnotation(ExcelRequired.class) != null);
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (Object field : fields) {
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            WriteFont headWriteFont = new WriteFont();
            headWriteCellStyle.setWriteFont(headWriteFont);
            result.add(((Field)field).getName());
        }
        return result;
    }
}

