/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageInfo;
import com.lframework.starter.common.utils.BeanUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.common.utils.ObjectUtil;
import com.lframework.starter.web.resp.PageResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.NonNull;

public class PageResultUtil {
    public static <T> PageResult<T> convert(@NonNull IPage<T> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return PageResultUtil.convert(page, null);
    }

    public static <T> PageResult<T> convert(@NonNull PageInfo<T> pageInfo) {
        if (pageInfo == null) {
            throw new NullPointerException("pageInfo is marked non-null but is null");
        }
        return PageResultUtil.convert(pageInfo, null);
    }

    public static <T> PageResult<T> convert(@NotNull IPage<T> page, Map<Object, Object> extra) {
        PageResult pageResult = new PageResult();
        ArrayList datas = new ArrayList(page.getRecords());
        pageResult.setDatas(datas);
        pageResult.setHasNext(page.getCurrent() > 1L);
        pageResult.setHasPrev(page.getCurrent() < page.getPages());
        pageResult.setPageIndex(page.getCurrent());
        pageResult.setPageSize(page.getSize());
        pageResult.setTotalCount(page.getTotal());
        pageResult.setTotalPage((int)page.getPages());
        if (!ObjectUtil.isEmpty(extra)) {
            pageResult.setExtra(extra);
        }
        return pageResult;
    }

    public static <T> PageResult<T> convert(@NonNull PageInfo<T> pageInfo, Map<Object, Object> extra) {
        if (pageInfo == null) {
            throw new NullPointerException("pageInfo is marked non-null but is null");
        }
        PageResult pageResult = new PageResult();
        ArrayList datas = new ArrayList(pageInfo.getList());
        pageResult.setDatas(datas);
        pageResult.setHasNext(pageInfo.isHasNextPage());
        pageResult.setHasPrev(pageInfo.isHasPreviousPage());
        pageResult.setPageIndex(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        pageResult.setTotalCount(pageInfo.getTotal());
        pageResult.setTotalPage(pageInfo.getPages());
        if (!ObjectUtil.isEmpty(extra)) {
            pageResult.setExtra(extra);
        }
        return pageResult;
    }

    public static <T> PageResult<T> rebuild(PageResult pageResult, List<T> datas) {
        PageResult<T> result = new PageResult<T>();
        BeanUtil.copyProperties((Object)pageResult, result, (String[])new String[]{"datas"});
        result.setDatas(datas == null ? CollectionUtil.emptyList() : datas);
        pageResult.setDatas(datas);
        return result;
    }

    public static <T> PageResult<T> newInstance(long pageIndex, long pageSize, long totalCount, List<T> datas) {
        return PageResultUtil.newInstance(pageIndex, pageSize, totalCount, datas, null);
    }

    public static <T> PageResult<T> newInstance(long pageIndex, long pageSize, long totalCount, List<T> datas, Map<Object, Object> extra) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.setTotalCount(totalCount);
        pageResult.setPageSize(pageSize);
        pageResult.setPageIndex(pageIndex);
        pageResult.setTotalPage((int)(totalCount / pageSize) + (totalCount % pageSize > 0L ? 1 : 0));
        pageResult.setDatas(datas);
        pageResult.setExtra(extra);
        pageResult.setHasNext(pageResult.getPageIndex() < (long)pageResult.getTotalPage());
        pageResult.setHasPrev(pageResult.getPageIndex() > 1L);
        return pageResult;
    }
}

